/*
 * Decompiled with CFR 0.152.
 */
package com.chrisplus.rootmanager;

import android.text.TextUtils;
import com.chrisplus.rootmanager.Constants;
import com.chrisplus.rootmanager.container.Command;
import com.chrisplus.rootmanager.container.Result;
import com.chrisplus.rootmanager.container.Shell;
import com.chrisplus.rootmanager.exception.PermissionException;
import com.chrisplus.rootmanager.utils.Remounter;
import com.chrisplus.rootmanager.utils.RootUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class RootManager {
    private static RootManager instance;
    private static boolean accessRoot;
    private Boolean hasRooted = null;
    private boolean hasGivenPermission = false;
    private long lastPermissionCheck = -1L;

    private RootManager() {
    }

    public static synchronized RootManager getInstance() {
        if (instance == null) {
            instance = new RootManager();
        }
        return instance;
    }

    public boolean hasRooted() {
        if (this.hasRooted == null) {
            for (String path : Constants.SU_BINARY_DIRS) {
                File su = new File(path + "/su");
                if (su.exists()) {
                    this.hasRooted = true;
                    break;
                }
                this.hasRooted = false;
            }
        }
        return this.hasRooted;
    }

    public boolean obtainPermission() {
        if (!this.hasGivenPermission) {
            this.hasGivenPermission = this.accessRoot();
            this.lastPermissionCheck = System.currentTimeMillis();
        } else if (this.lastPermissionCheck < 0L || System.currentTimeMillis() - this.lastPermissionCheck > 600000L) {
            this.hasGivenPermission = this.accessRoot();
            this.lastPermissionCheck = System.currentTimeMillis();
        }
        return this.hasGivenPermission;
    }

    public Result installPackage(String apkPath) {
        return this.installPackage(apkPath, "a");
    }

    public Result installPackage(String apkPath, String installLocation) {
        RootUtils.checkUIThread();
        final Result.ResultBuilder builder = Result.newBuilder();
        if (TextUtils.isEmpty((CharSequence)apkPath)) {
            return builder.setFailed().build();
        }
        String command = "pm install -r ";
        if (RootUtils.isNeedPathSDK()) {
            command = "LD_LIBRARY_PATH=/vendor/lib:/system/lib " + command;
        }
        command = command + apkPath;
        if (TextUtils.isEmpty((CharSequence)installLocation)) {
            if (installLocation.equalsIgnoreCase("ex")) {
                command = command + "-s ";
            } else if (installLocation.equalsIgnoreCase("in")) {
                command = command + "-f ";
            }
        }
        final StringBuilder infoSb = new StringBuilder();
        Command commandImpl = new Command(new String[]{command}){

            @Override
            public void onUpdate(int id, String message) {
                infoSb.append(message + "\n");
            }

            @Override
            public void onFinished(int id) {
                String finalInfo = infoSb.toString();
                if (TextUtils.isEmpty((CharSequence)finalInfo)) {
                    builder.setInstallFailed();
                } else if (finalInfo.contains("success") || finalInfo.contains("Success")) {
                    builder.setInstallSuccess();
                } else if (finalInfo.contains("failed") || finalInfo.contains("FAILED")) {
                    if (finalInfo.contains("FAILED_INSUFFICIENT_STORAGE")) {
                        builder.setInsallFailedNoSpace();
                    } else if (finalInfo.contains("FAILED_INCONSISTENT_CERTIFICATES")) {
                        builder.setInstallFailedWrongCer();
                    } else if (finalInfo.contains("FAILED_CONTAINER_ERROR")) {
                        builder.setInstallFailedWrongCer();
                    } else {
                        builder.setInstallFailed();
                    }
                } else {
                    builder.setInstallFailed();
                }
            }
        };
        try {
            Shell.startRootShell().add(commandImpl).waitForFinish();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            builder.setCommandFailedInterrupted();
        }
        catch (IOException e) {
            e.printStackTrace();
            builder.setCommandFailed();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            builder.setCommandFailedTimeout();
        }
        catch (PermissionException e) {
            e.printStackTrace();
            builder.setCommandFailedDenied();
        }
        return builder.build();
    }

    public Result uninstallPackage(String packageName) {
        RootUtils.checkUIThread();
        final Result.ResultBuilder builder = Result.newBuilder();
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return builder.setFailed().build();
        }
        String command = "pm uninstall " + packageName;
        final StringBuilder infoSb = new StringBuilder();
        Command commandImpl = new Command(new String[]{command}){

            @Override
            public void onUpdate(int id, String message) {
                infoSb.append(message + "\n");
            }

            @Override
            public void onFinished(int id) {
                String finalInfo = infoSb.toString();
                if (TextUtils.isEmpty((CharSequence)finalInfo)) {
                    builder.setUninstallFailed();
                } else if (finalInfo.contains("Success") || finalInfo.contains("success")) {
                    builder.setUninstallSuccess();
                } else {
                    builder.setUninstallFailed();
                }
            }
        };
        try {
            Shell.startRootShell().add(commandImpl).waitForFinish();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            builder.setCommandFailedInterrupted();
        }
        catch (IOException e) {
            e.printStackTrace();
            builder.setCommandFailed();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            builder.setCommandFailedTimeout();
        }
        catch (PermissionException e) {
            e.printStackTrace();
            builder.setCommandFailedDenied();
        }
        return builder.build();
    }

    public Result uninstallSystemApp(String apkPath) {
        File apkFile;
        RootUtils.checkUIThread();
        Result.ResultBuilder builder = Result.newBuilder();
        if (TextUtils.isEmpty((CharSequence)apkPath)) {
            return builder.setFailed().build();
        }
        if (this.remount("/system/", "rw") && (apkFile = new File(apkPath)).exists()) {
            return this.runCommand("rm '" + apkPath + "'");
        }
        return builder.setFailed().build();
    }

    public boolean installBinary(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        return this.copyFile(filePath, "/system/bin/");
    }

    public boolean removeBinary(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return false;
        }
        File file = new File("/system/bin/" + fileName);
        if (!file.exists()) {
            return false;
        }
        if (this.remount("/system/", "rw")) {
            return this.runCommand("rm '/system/bin/" + fileName + "'").getResult();
        }
        return false;
    }

    public boolean copyFile(String source, String destinationDir) {
        if (TextUtils.isEmpty((CharSequence)destinationDir) || TextUtils.isEmpty((CharSequence)source)) {
            return false;
        }
        File sourceFile = new File(source);
        File desFile = new File(destinationDir);
        if (!sourceFile.exists() || !desFile.isDirectory()) {
            return false;
        }
        if (this.remount(destinationDir, "rw")) {
            return this.runCommand("cat '" + source + "' > " + destinationDir).getResult();
        }
        return false;
    }

    public boolean remount(String path, String mountType) {
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)mountType)) {
            return false;
        }
        if (mountType.equalsIgnoreCase("rw") || mountType.equalsIgnoreCase("ro")) {
            return Remounter.remount(path, mountType);
        }
        return false;
    }

    public Result runBinBinary(String binaryName) {
        Result.ResultBuilder builder = Result.newBuilder();
        if (TextUtils.isEmpty((CharSequence)binaryName)) {
            return builder.setFailed().build();
        }
        return this.runBinary("/system/bin/" + binaryName);
    }

    public Result runBinary(String path) {
        return this.runCommand(path);
    }

    public Result runCommand(String command) {
        final Result.ResultBuilder builder = Result.newBuilder();
        if (TextUtils.isEmpty((CharSequence)command)) {
            return builder.setFailed().build();
        }
        final StringBuilder infoSb = new StringBuilder();
        Command commandImpl = new Command(new String[]{command}){

            @Override
            public void onUpdate(int id, String message) {
                infoSb.append(message + "\n");
            }

            @Override
            public void onFinished(int id) {
                builder.setCustomMessage(infoSb.toString());
            }
        };
        try {
            Shell.startRootShell().add(commandImpl).waitForFinish();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            builder.setCommandFailedInterrupted();
        }
        catch (IOException e) {
            e.printStackTrace();
            builder.setCommandFailed();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            builder.setCommandFailedTimeout();
        }
        catch (PermissionException e) {
            e.printStackTrace();
            builder.setCommandFailedDenied();
        }
        return builder.build();
    }

    public boolean screenCap(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        Result res = this.runCommand("screencap " + path);
        RootUtils.Log((res == null) + "");
        return res.getResult();
    }

    public boolean screenRecord(String path) {
        return this.screenRecord(path, 4000000L, 30L);
    }

    public boolean screenRecord(String path, long bitRate, long time) {
        if (!RootUtils.isKitKatUpper() || TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        Result res = this.runCommand("screenrecord --bit-rate " + bitRate + " --time-limit " + time + " " + path);
        return res.getResult();
    }

    public boolean isProcessRunning(String processName) {
        if (TextUtils.isEmpty((CharSequence)processName)) {
            return false;
        }
        Result infos = this.runCommand("ps");
        return infos.getMessage().contains(processName);
    }

    public boolean killProcessByName(String processName) {
        if (TextUtils.isEmpty((CharSequence)processName)) {
            return false;
        }
        Result res = this.runCommand("pidof " + processName);
        if (!TextUtils.isEmpty((CharSequence)res.getMessage())) {
            return this.killProcessById(res.getMessage());
        }
        return false;
    }

    public boolean killProcessById(String processID) {
        if (TextUtils.isEmpty((CharSequence)processID)) {
            return false;
        }
        Result res = this.runCommand("kill " + processID);
        return res.getResult();
    }

    public void restartDevice() {
        this.killProcessByName("zygote");
    }

    private boolean accessRoot() {
        boolean result = false;
        accessRoot = false;
        Command commandImpl = new Command(new String[]{"id"}){

            @Override
            public void onUpdate(int id, String message) {
                if (message != null && message.toLowerCase().contains("uid=0")) {
                    accessRoot = true;
                }
            }

            @Override
            public void onFinished(int id) {
            }
        };
        try {
            Shell.startRootShell().add(commandImpl).waitForFinish();
            result = accessRoot;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            result = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            result = false;
        }
        catch (PermissionException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    static {
        accessRoot = false;
    }
}

