/*
 * Decompiled with CFR 0.152.
 */
package com.chootdev.csnackbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.chootdev.csnackbar.Align;
import com.chootdev.csnackbar.Duration;
import com.chootdev.csnackbar.Type;

public class Snackbar {
    private static Context snackContext;
    private static android.support.design.widget.Snackbar snackbar;
    private static Snackbar singleton;
    private static int colorCode;
    private static String snackMessage;
    private static int snackDuration;
    private static View view;
    private static boolean isCustomView;
    private static boolean isFillParent;
    private static Align textAlign;

    public static Snackbar with(Context context, View fab) {
        snackContext = context.getApplicationContext();
        if (singleton == null) {
            singleton = new Snackbar();
        }
        if (fab == null) {
            View rootView;
            view = rootView = ((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
            snackbar = android.support.design.widget.Snackbar.make((View)view, (CharSequence)"", (int)snackDuration);
        } else {
            view = fab;
            snackbar = android.support.design.widget.Snackbar.make((View)view, (CharSequence)"", (int)snackDuration);
        }
        isCustomView = false;
        isFillParent = false;
        textAlign = Align.LEFT;
        return singleton;
    }

    public static Snackbar type(Type type) {
        colorCode = Type.getColorCode(type);
        return singleton;
    }

    public static Snackbar type(Type type, int color) {
        colorCode = type == Type.CUSTOM ? color : Type.getColorCode(type);
        return singleton;
    }

    public static Snackbar message(CharSequence displayingMessage) {
        snackMessage = displayingMessage.toString();
        return singleton;
    }

    public static Snackbar duration(Duration duration) {
        if (duration != Duration.CUSTOM) {
            snackDuration = Duration.getDuration(duration);
        }
        return singleton;
    }

    public static Snackbar duration(Duration durationType, int duration) {
        if (durationType == Duration.CUSTOM) {
            snackDuration = duration;
        }
        return singleton;
    }

    public static Snackbar contentView(View view, int heightInDp) {
        isCustomView = true;
        Snackbar.SnackbarLayout snackLayout = (Snackbar.SnackbarLayout)snackbar.getView();
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)snackLayout.getLayoutParams();
        params.height = (int)Snackbar.pxFromDp(heightInDp);
        TextView textView = (TextView)snackLayout.findViewById(R.id.snackbar_text);
        textView.setVisibility(4);
        snackLayout.addView(view, 0, (ViewGroup.LayoutParams)params);
        return singleton;
    }

    public static Snackbar fillParent(boolean fillParent) {
        isFillParent = fillParent;
        return singleton;
    }

    public static Snackbar textAlign(Align align) {
        textAlign = align;
        return singleton;
    }

    private static View getSnackBarLayout() {
        if (snackbar != null) {
            return snackbar.getView();
        }
        return null;
    }

    private static Snackbar setColor(int colorId) {
        View snackBarView = Snackbar.getSnackBarLayout();
        if (snackBarView != null) {
            snackBarView.setBackgroundColor(colorId);
        }
        return singleton;
    }

    private static void setTextAlignment(android.support.design.widget.Snackbar snackbar) {
        TextView textView = (TextView)snackbar.getView().findViewById(R.id.snackbar_text);
        switch (textAlign) {
            case CENTER: {
                if (Build.VERSION.SDK_INT >= 23) {
                    textView.setTextAlignment(4);
                    break;
                }
                textView.setGravity(1);
                break;
            }
            case RIGHT: {
                if (Build.VERSION.SDK_INT >= 23) {
                    textView.setTextAlignment(6);
                    break;
                }
                textView.setGravity(5);
                break;
            }
            case LEFT: {
                if (Build.VERSION.SDK_INT >= 23) {
                    textView.setTextAlignment(5);
                    break;
                }
                textView.setGravity(3);
                break;
            }
            default: {
                if (Build.VERSION.SDK_INT >= 23) {
                    textView.setTextAlignment(5);
                    break;
                }
                textView.setGravity(3);
            }
        }
    }

    public static void show() {
        if (isCustomView) {
            snackbar.setDuration(snackDuration);
            snackbar.show();
        } else {
            snackbar = (android.support.design.widget.Snackbar)android.support.design.widget.Snackbar.make((View)view, (CharSequence)snackMessage, (int)snackDuration).setDuration(snackDuration);
            if (isFillParent) {
                Snackbar.snackbar.getView().getLayoutParams().width = -1;
            }
            Snackbar.setTextAlignment(snackbar);
            Snackbar.setColor(colorCode);
            View snackbarView = snackbar.getView();
            TextView textView = (TextView)snackbarView.findViewById(R.id.snackbar_text);
            textView.setMaxLines(10);
        }
        snackbar.show();
    }

    private static float pxFromDp(int dp) {
        return (float)dp * Snackbar.snackContext.getResources().getDisplayMetrics().density;
    }

    public static void dismiss() {
        if (snackbar != null && snackbar.isShown()) {
            snackbar.dismiss();
        }
    }

    static {
        colorCode = Type.getColorCode(Type.SUCCESS);
        snackMessage = "Hi there !";
        snackDuration = Duration.getDuration(Duration.SHORT);
    }
}

