/*
 * Decompiled with CFR 0.152.
 */
package com.chiranjit.badgenavigationview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.design.internal.BottomNavigationItemView;
import android.support.design.internal.BottomNavigationMenuView;
import android.support.design.widget.BottomNavigationView;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.chiranjit.badgenavigationview.R;
import java.util.ArrayList;
import java.util.List;

public class BadgeBottomNavigation
extends BottomNavigationView {
    private BottomNavigationMenuView bottomNavigationMenuView;
    private List<TextView> badgeList = new ArrayList<TextView>();
    private Context context;
    private int badgeColor = R.color.badge_color;
    private int badgeTextColor = R.color.badge_text_color;
    private boolean isCircleBadge = false;

    public BadgeBottomNavigation(Context context) {
        super(context);
        this.context = context;
    }

    public BadgeBottomNavigation(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public BadgeBottomNavigation(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    private void init() {
        this.bottomNavigationMenuView = (BottomNavigationMenuView)this.getChildAt(0);
        for (int index = 0; index < this.bottomNavigationMenuView.getChildCount(); ++index) {
            try {
                View v = this.bottomNavigationMenuView.getChildAt(index);
                BottomNavigationItemView itemView = (BottomNavigationItemView)v;
                FrameLayout badgeView = (FrameLayout)LayoutInflater.from((Context)this.context).inflate(R.layout.layout_notification_badge, (ViewGroup)this, false);
                itemView.addView((View)badgeView);
                TextView notifications_badge = (TextView)badgeView.getChildAt(0);
                notifications_badge.setTag((Object)index);
                this.badgeList.add(notifications_badge);
                notifications_badge.setVisibility(8);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setBadgeColor(int badgeColor) {
        this.badgeColor = badgeColor;
    }

    public void setBadgeTextColor(int badgeTextColor) {
        this.badgeTextColor = badgeTextColor;
    }

    public void setRoundBadge(boolean isCircleBadge) {
        this.isCircleBadge = isCircleBadge;
    }

    public void setBadge(int badge, int mIndex) {
        try {
            if (this.bottomNavigationMenuView == null) {
                this.init();
            }
            TextView notifications_badge = (TextView)this.badgeList.get(mIndex).findViewWithTag((Object)mIndex);
            if (badge > 0) {
                notifications_badge.setVisibility(0);
                notifications_badge.setText((CharSequence)String.valueOf(badge));
            } else {
                notifications_badge.setVisibility(8);
            }
            Drawable drawable2 = notifications_badge.getBackground();
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            DrawableCompat.setTint((Drawable)drawable2, (int)ContextCompat.getColor((Context)this.context, (int)this.badgeColor));
            notifications_badge.setBackground(drawable2);
            notifications_badge.setTextColor(ContextCompat.getColor((Context)this.context, (int)this.badgeTextColor));
            if (this.isCircleBadge) {
                notifications_badge.setBackground(this.getResources().getDrawable(R.drawable.ic_round_badge));
            } else {
                notifications_badge.setBackground(this.getResources().getDrawable(R.drawable.ic_rect_badge));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

