/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.utils;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.math.BigDecimal;

public class CacheManager {
    public static String getTotalCacheSize(Context context) throws Exception {
        long cacheSize = CacheManager.getFolderSize(context.getCacheDir());
        if (Environment.getExternalStorageState().equals("mounted")) {
            cacheSize += CacheManager.getFolderSize(context.getExternalCacheDir());
        }
        return CacheManager.getFormatSize(cacheSize);
    }

    public static long getFolderSize(File file) throws Exception {
        long size = 0L;
        try {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += CacheManager.getFolderSize(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static String getFormatSize(double size) {
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return "0K";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }

    public static void cleanInternalCache(Context context) {
        CacheManager.deleteFilesByDirectory(context.getCacheDir());
    }

    public static void cleanDatabases(Context context) {
        CacheManager.deleteFilesByDirectory(new File("/data/data/" + context.getPackageName() + "/databases"));
    }

    public static void cleanSharedPreference(Context context) {
        CacheManager.deleteFilesByDirectory(new File("/data/data/" + context.getPackageName() + "/shared_prefs"));
    }

    public static void cleanDatabaseByName(Context context, String dbName) {
        context.deleteDatabase(dbName);
    }

    public static void cleanFiles(Context context) {
        CacheManager.deleteFilesByDirectory(context.getFilesDir());
    }

    public static void cleanExternalCache(Context context) {
        if (Environment.getExternalStorageState().equals("mounted")) {
            CacheManager.deleteFilesByDirectory(context.getExternalCacheDir());
        }
    }

    public static void cleanCustomCache(String filePath) {
        CacheManager.deleteFilesByDirectory(new File(filePath));
    }

    public static void cleanApplicationData(Context context, String ... filepath) {
        CacheManager.cleanInternalCache(context);
        CacheManager.cleanExternalCache(context);
        CacheManager.cleanDatabases(context);
        CacheManager.cleanFiles(context);
        for (String filePath : filepath) {
            CacheManager.cleanCustomCache(filePath);
        }
    }

    private static void deleteFilesByDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            for (File item : directory.listFiles()) {
                item.delete();
            }
        }
    }

    public static void clearAllCache(Context context) {
        CacheManager.deleteDir(context.getCacheDir());
        if (Environment.getExternalStorageState().equals("mounted")) {
            CacheManager.deleteDir(context.getExternalCacheDir());
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = CacheManager.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

