/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.utils;

import android.os.Build;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccountUtil {
    public static String LongToString(double l) {
        NumberFormat format = NumberFormat.getCurrencyInstance();
        String ff = format.format(l);
        return ff.substring(1, ff.length());
    }

    public static String LongToStringCn(long l) {
        NumberFormat format = NumberFormat.getCurrencyInstance(Locale.CHINA);
        return format.format(l);
    }

    public static long MoneyTolong(String money) {
        String regEx = "[,.]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(money);
        String trim = m.replaceAll("").trim();
        String money1 = trim.substring(0, trim.length() - 2);
        long l = Long.parseLong(money1);
        return l;
    }

    public static String StringToMString(String s) {
        long ll = Long.parseLong(s);
        String s1 = AccountUtil.LongToString(ll);
        return s1;
    }

    public static String DoubleToString(double availableCredit) {
        if (0.0 == availableCredit) {
            return "0.00";
        }
        NumberFormat format = NumberFormat.getCurrencyInstance();
        String ff = format.format(availableCredit);
        if (Build.VERSION.SDK_INT >= 21) {
            return ff.substring(1, ff.length());
        }
        return ff.substring(1, ff.length());
    }

    public static String parseNum(double Num) {
        double result = Num / 10000.0;
        BigDecimal b = new BigDecimal(result);
        double f1 = b.setScale(2, 4).doubleValue();
        String str = f1 + "";
        if (str.indexOf(".") == str.length() - 2) {
            str = str + "0";
        }
        return str;
    }

    public static String doubleToString(double num) {
        return new DecimalFormat("0.00").format(num);
    }

    public static String nameSecret(String string) {
        String newString = string.substring(string.length() - 1, string.length());
        return "***" + newString;
    }

    public static String phoneSecret(String s) {
        String head = s.substring(0, 3);
        String end = s.substring(s.length() - 4, s.length());
        return head + "****" + end;
    }

    public static Double sub(Double v1, Double v2) {
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.subtract(b2).doubleValue();
    }

    public static Double sub2(String v1, String v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).doubleValue();
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static String getRemainAmount(String remain) {
        if (remain != null && remain != "") {
            if (Double.valueOf(remain) >= 10000.0) {
                return AccountUtil.parseNum(Double.valueOf(remain)) + "\u4e07";
            }
            return remain + "";
        }
        return remain + "";
    }
}

