/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.retrofit;

import android.content.Context;
import android.util.Log;
import com.chinazyjr.mylibrary.retrofit.ProgressCancelListener;
import com.chinazyjr.mylibrary.retrofit.ProgressDialogHandler;
import com.chinazyjr.mylibrary.retrofit.SubscriberOnNextListener;
import rx.Subscriber;

public class ProgressSubscriber<T>
extends Subscriber<T>
implements ProgressCancelListener {
    private static final String TAG = "ProgressSubscriber";
    String tag = this.getClass().getSimpleName();
    private SubscriberOnNextListener<T> mSubscriberOnNextListener;
    private ProgressDialogHandler mProgressDialogHandler;
    private Context context;

    public ProgressSubscriber(SubscriberOnNextListener<T> mSubscriberOnNextListener, Context context) {
        this.mSubscriberOnNextListener = mSubscriberOnNextListener;
        this.context = context;
        this.mProgressDialogHandler = new ProgressDialogHandler(context, this, true);
    }

    private void showProgressDialog() {
        if (this.mProgressDialogHandler != null) {
            this.mProgressDialogHandler.obtainMessage(1).sendToTarget();
        }
    }

    private void dismissProgressDialog() {
        if (this.mProgressDialogHandler != null) {
            this.mProgressDialogHandler.obtainMessage(2).sendToTarget();
            this.mProgressDialogHandler = null;
        }
    }

    public void onStart() {
        this.showProgressDialog();
    }

    public void onCompleted() {
        this.dismissProgressDialog();
    }

    public void onError(Throwable e) {
        Log.e((String)TAG, (String)("onError: " + e.getMessage()));
        this.dismissProgressDialog();
        this.mSubscriberOnNextListener.onError(e);
    }

    public void onNext(T t) {
        this.mSubscriberOnNextListener.onNext(t);
    }

    @Override
    public void onCancelProgress() {
        if (!this.isUnsubscribed()) {
            this.unsubscribe();
        }
    }
}

