/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.utils;

import android.content.SharedPreferences;
import org.opencv.chinaredstar.HxFaceLibrary;

public class PreferencesUtils {
    public static String PREFERENCE_NAME = "SP_HxFaceLibrary";

    private PreferencesUtils() {
        throw new AssertionError();
    }

    public static boolean putString(String key, String value) {
        return PreferencesUtils.putString(PREFERENCE_NAME, key, value);
    }

    public static boolean putString(String prefreence_name, String key, String value) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(prefreence_name, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public static String getString(String key) {
        return PreferencesUtils.getString(key, null);
    }

    public static String getString(String key, String defaultValue) {
        return PreferencesUtils.getString(PREFERENCE_NAME, key, defaultValue);
    }

    public static String getString(String prefreence_name, String key, String defaultValue) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(prefreence_name, 0);
        return settings.getString(key, defaultValue);
    }

    public static boolean putInt(String key, int value) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value);
        return editor.commit();
    }

    public static int getInt(String key) {
        return PreferencesUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        return settings.getInt(key, defaultValue);
    }

    public static boolean putLong(String key, long value) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putLong(key, value);
        return editor.commit();
    }

    public static long getLong(String key) {
        return PreferencesUtils.getLong(key, -1L);
    }

    public static long getLong(String key, long defaultValue) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        return settings.getLong(key, defaultValue);
    }

    public static boolean putFloat(String key, float value) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putFloat(key, value);
        return editor.commit();
    }

    public static float getFloat(String key) {
        return PreferencesUtils.getFloat(key, -1.0f);
    }

    public static float getFloat(String key, float defaultValue) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        return settings.getFloat(key, defaultValue);
    }

    public static boolean putBoolean(String key, boolean value) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(key, value);
        return editor.commit();
    }

    public static boolean getBoolean(String key) {
        return PreferencesUtils.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        SharedPreferences settings = HxFaceLibrary.getApp().getSharedPreferences(PREFERENCE_NAME, 0);
        return settings.getBoolean(key, defaultValue);
    }
}

