/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.utils;

import android.annotation.SuppressLint;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.location.LocationManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import org.opencv.chinaredstar.HxFaceLibrary;

public class DeviceUtils {
    public static boolean isGpsEnabled() {
        LocationManager lm = (LocationManager)HxFaceLibrary.getApp().getSystemService("location");
        List accessibleProviders = lm.getProviders(true);
        for (String name : accessibleProviders) {
            if (!"gps".equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String getNetworkOperatorName() {
        TelephonyManager telephonyManager = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
        return telephonyManager.getSimOperatorName();
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceId() {
        String deviceId = null;
        TelephonyManager telephonyManager = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
        if (Build.VERSION.SDK_INT < 23) {
            deviceId = telephonyManager.getDeviceId();
        }
        if (deviceId == null || deviceId.isEmpty()) {
            deviceId = Settings.Secure.getString((ContentResolver)HxFaceLibrary.getApp().getContentResolver(), (String)"android_id");
        }
        if (!TextUtils.isEmpty((CharSequence)(deviceId = telephonyManager.getDeviceId()))) {
            deviceId = deviceId.toLowerCase();
            if (!TextUtils.isEmpty((CharSequence)(deviceId = deviceId.replace("imei", "")))) {
                deviceId = deviceId.replace(":", "");
                return deviceId.trim();
            }
        }
        return deviceId;
    }

    public static String getAndroidId() {
        return Settings.Secure.getString((ContentResolver)HxFaceLibrary.getApp().getContentResolver(), (String)"android_id");
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getIMSINumber() {
        TelephonyManager telephonyManager = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
        return telephonyManager.getSubscriberId();
    }

    public static String getMACAddress() {
        WifiManager wifiManager = (WifiManager)HxFaceLibrary.getApp().getApplicationContext().getSystemService("wifi");
        WifiInfo wInfo = wifiManager.getConnectionInfo();
        return wInfo.getMacAddress();
    }

    public static String getMACAddressByFile() {
        String macSerial = null;
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getSimSerialNumber() {
        TelephonyManager telephonyManager = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
        return telephonyManager.getSimSerialNumber();
    }

    public static String getDeviceSerialNumber() {
        return Build.SERIAL;
    }

    public static List<Sensor> getAllSensors() {
        SensorManager sensorManager = (SensorManager)HxFaceLibrary.getApp().getSystemService("sensor");
        return sensorManager.getSensorList(-1);
    }

    public static int getProcessCpuRate() {
        int rate = 0;
        try {
            String Result;
            Process p = Runtime.getRuntime().exec("top -n 1 -m 1  -s cpu");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((Result = br.readLine()) != null) {
                if (Result.trim().length() < 1) continue;
                String[] CPUusr = Result.split("%");
                String[] CPUusage = CPUusr[0].split("User");
                String[] SYSusage = CPUusr[1].split("System");
                rate = Integer.parseInt(CPUusage[1].trim()) + Integer.parseInt(SYSusage[1].trim());
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rate;
    }

    public static void copyClipBoard(String content) {
        ClipboardManager cmb = (ClipboardManager)HxFaceLibrary.getApp().getSystemService("clipboard");
        cmb.setText((CharSequence)content.trim());
    }
}

