package org.opencv.chinaredstar.service.mvp;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;

import com.lzy.okgo.model.Response;

import org.json.JSONException;
import org.json.JSONObject;
import org.opencv.chinaredstar.HxFaceLibrary;
import org.opencv.chinaredstar.bean.HxRecommendBean;
import org.opencv.chinaredstar.bean.SearchFaceResultBean;
import org.opencv.chinaredstar.constants.ApiContants;
import org.opencv.chinaredstar.net.HttpUtils;
import org.opencv.chinaredstar.net.JsonCallback;
import org.opencv.chinaredstar.utils.DeviceInfo;

/**
 * Created by xiaodong.jin on 2018/11/22.
 * description：
 */

public class SearchFacePresenter {

    private String currentFaceId = "";
    private long time = 0;//同一个faceID五秒之内不去更新信息
    private Context mContext;
    private IsearchFaceView mView;

    public SearchFacePresenter(Context context, IsearchFaceView view) {
        mContext = context;
        mView = view;

    }

    public void searchFace(final Bitmap bitmap, String imageFace) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mallId", "10062");
            jsonObject.put("deviceId", DeviceInfo.getDeviceId());
            jsonObject.put("macAddress", DeviceInfo.getMacAddressFromIp());
            jsonObject.put("ipAddress", DeviceInfo.getIpAddress());
            jsonObject.put("time", System.currentTimeMillis() + "");
            jsonObject.put("faceImage", imageFace);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        Log.e("params", jsonObject.toString());
        HttpUtils.getInstance().post("", ApiContants.HX_FACE_SEARCH, null, jsonObject.toString(), new JsonCallback<SearchFaceResultBean>() {
            @Override
            public void onSuccess(Response<SearchFaceResultBean> response) {
                if (response.body() != null) {
                    SearchFaceResultBean resultBean = response.body();
                    if (resultBean.status == 200 && resultBean != null && !TextUtils.isEmpty(resultBean.value)) {
                        if (currentFaceId.equals(resultBean.value) && resultBean.timestamp - time < 1000 * 60 * 10) {
                            Log.e("SearchFacePresenter", "同一个id或时间小于2s");
                        } else {
                            currentFaceId = resultBean.value;
                            Log.e("SearchFacePresenter", "getRecommendAd" + currentFaceId);
                            //获取推荐数据
                            getRecommendAd(bitmap, currentFaceId);
                        }
                        return;
                    }
                }
                Log.e("SearchFacePresenter", "searchFace_error");
            }

            @Override
            public void onError(Response<SearchFaceResultBean> response) {
                super.onError(response);
                Log.e("SearchFacePresenter", "searchFace_error" + response.message());
            }

            @Override
            public void onFinish() {
                super.onFinish();
                mView.onCanSearch(true);
                Log.e("SearchFacePresenter", "finish");

            }
        });
    }

    public void getRecommendAd(final Bitmap bitmap, final String rsProfileId) {
        Log.e("SearchFacePresenter", "getRecommendAd");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mallId", "10062");
            jsonObject.put("deviceId", DeviceInfo.getDeviceId());
            jsonObject.put("macAddress", DeviceInfo.getMacAddressFromIp());
            jsonObject.put("ipAddress", DeviceInfo.getIpAddress());
            jsonObject.put("time", System.currentTimeMillis() + "");
            jsonObject.put("floor", HxFaceLibrary.mfloor);//楼层号
            jsonObject.put("rsProfileId", rsProfileId);//红星人脸档案ID
        } catch (JSONException e) {
            e.printStackTrace();
        }
        Log.e("SearchFacePresenter", "getRecommendAd" + jsonObject.toString());
        HttpUtils.getInstance().post("", ApiContants.HX_FACE_RECOMMENDAD, null, jsonObject.toString(), new JsonCallback<HxRecommendBean>() {
            @Override
            public void onSuccess(Response<HxRecommendBean> response) {
                if (response.body() != null) {
                    HxRecommendBean body = response.body();
                    if (body.status == 200 && body.value != null) {
                        time = body.timestamp;
                        body.rsProfileId = rsProfileId;
                        mView.onSearchSuccess(bitmap, body);
                        return;
                    }
                }
                Log.e("SearchFacePresenter", response.message());
            }

            @Override
            public void onError(Response<HxRecommendBean> response) {
                super.onError(response);
                Log.e("SearchFace_onError", response.message());
            }

            @Override
            public void onFinish() {
                super.onFinish();
                mView.onCanSearch(true);
            }
        });
    }


}
