/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.service;

import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;

public class DetectionBasedTracker {
    private long mNativeObj = 0L;

    public DetectionBasedTracker(String cascadeName, int minFaceSize) {
        this.mNativeObj = DetectionBasedTracker.nativeCreateObject(cascadeName, minFaceSize);
    }

    public void start() {
        DetectionBasedTracker.nativeStart(this.mNativeObj);
    }

    public void stop() {
        DetectionBasedTracker.nativeStop(this.mNativeObj);
    }

    public void setMinFaceSize(int size) {
        DetectionBasedTracker.nativeSetFaceSize(this.mNativeObj, size);
    }

    public void detect(Mat imageGray, MatOfRect faces) {
        DetectionBasedTracker.nativeDetect(this.mNativeObj, imageGray.getNativeObjAddr(), faces.getNativeObjAddr());
    }

    public void release() {
        DetectionBasedTracker.nativeDestroyObject(this.mNativeObj);
        this.mNativeObj = 0L;
    }

    private static native long nativeCreateObject(String var0, int var1);

    private static native void nativeDestroyObject(long var0);

    private static native void nativeStart(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeSetFaceSize(long var0, int var2);

    private static native void nativeDetect(long var0, long var2, long var4);
}

