package org.opencv.chinaredstar.net;

import com.lzy.okgo.OkGo;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;

import org.opencv.chinaredstar.utils.DeviceInfo;

/**
 * Created by xiaodong.jin on 2018/11/21.
 * description：
 */
public class HttpUtils {

    private static HttpUtils mInstance;

    private HttpUtils() {

    }


    public static HttpUtils getInstance() {
        if (mInstance == null) {
            synchronized (HttpUtils.class) {
                if (mInstance == null) {
                    mInstance = new HttpUtils();
                }
            }
        }
        return mInstance;
    }


    public <T> void get(String tag, String url, HttpHeaders headers, HttpParams mParams, JsonCallback<BaseResponse<T>> callback) {
        mParams.put("", "");
        OkGo.<BaseResponse<T>>get(url)//
                .tag(tag)//
                .headers(headers)//
                .params(mParams)
                .execute(callback);
    }

    public <T> void post(String tag, String url, HttpHeaders headers, String mParams, JsonCallback<T> callback) {
        OkGo.<T>post(url)//
                .tag(tag)//
                .headers(headers)//
                .upJson(mParams)//强制使用 multipart/form-data 表单上传（只是演示，不需要的话不要设置。默认就是false）
                .execute(callback);
    }

    public HttpParams getParams() {
        HttpParams httpParams = new HttpParams();
        httpParams.put("mallId",10062);
        httpParams.put("deviceId", DeviceInfo.getDeviceId());
        httpParams.put("ipAddress", DeviceInfo.getIpAddress());
        httpParams.put("macAddress",DeviceInfo.getMacAddressFromIp());
        httpParams.put("time",System.currentTimeMillis());
        return httpParams;
    }
}
