/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.utils;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.opencv.chinaredstar.HxFaceLibrary;
import org.opencv.chinaredstar.utils.ShellUtils;

public class NetUtils {
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;

    public static void openWirelessSettings() {
        HxFaceLibrary.getApp().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    private static NetworkInfo getActiveNetworkInfo() {
        return ((ConnectivityManager)HxFaceLibrary.getApp().getSystemService("connectivity")).getActiveNetworkInfo();
    }

    public static boolean isConnected() {
        NetworkInfo info = NetUtils.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public static boolean isAvailableByPing() {
        return NetUtils.isAvailableByPing(null);
    }

    public static boolean isAvailableByPing(String ip) {
        boolean ret;
        if (ip == null || ip.length() <= 0) {
            ip = "223.5.5.5";
        }
        ShellUtils.CommandResult result = ShellUtils.execCmd(String.format("ping -c 1 %s", ip), false);
        boolean bl = ret = result.result == 0;
        if (result.errorMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + result.errorMsg));
        }
        if (result.successMsg != null) {
            Log.d((String)"NetworkUtils", (String)("isAvailableByPing() called" + result.successMsg));
        }
        return ret;
    }

    public static boolean getDataEnabled() {
        try {
            TelephonyManager tm = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
            Method getMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            if (null != getMobileDataEnabledMethod) {
                return (Boolean)getMobileDataEnabledMethod.invoke((Object)tm, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void setDataEnabled(boolean enabled) {
        try {
            TelephonyManager tm = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
            Method setMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            if (null != setMobileDataEnabledMethod) {
                setMobileDataEnabledMethod.invoke((Object)tm, enabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean is4G() {
        NetworkInfo info = NetUtils.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    public static boolean getWifiEnabled() {
        WifiManager wifiManager = (WifiManager)HxFaceLibrary.getApp().getSystemService("wifi");
        return wifiManager.isWifiEnabled();
    }

    public static void setWifiEnabled(boolean enabled) {
        WifiManager wifiManager = (WifiManager)HxFaceLibrary.getApp().getSystemService("wifi");
        if (enabled) {
            if (!wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(true);
            }
        } else if (wifiManager.isWifiEnabled()) {
            wifiManager.setWifiEnabled(false);
        }
    }

    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)HxFaceLibrary.getApp().getSystemService("connectivity");
        return cm != null && cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().getType() == 1;
    }

    public static boolean isWifiAvailable() {
        return NetUtils.getWifiEnabled() && NetUtils.isAvailableByPing();
    }

    public static String getNetworkOperatorName() {
        TelephonyManager tm = (TelephonyManager)HxFaceLibrary.getApp().getSystemService("phone");
        return tm != null ? tm.getNetworkOperatorName() : null;
    }

    public static NetworkType getNetworkType() {
        NetworkType netType = NetworkType.NETWORK_NO;
        NetworkInfo info = NetUtils.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 1) {
                netType = NetworkType.NETWORK_WIFI;
            } else if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        netType = NetworkType.NETWORK_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        netType = NetworkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        netType = NetworkType.NETWORK_4G;
                        break;
                    }
                    default: {
                        String subtypeName = info.getSubtypeName();
                        if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                            netType = NetworkType.NETWORK_3G;
                            break;
                        }
                        netType = NetworkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                netType = NetworkType.NETWORK_UNKNOWN;
            }
        }
        return netType;
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    boolean isIPv4;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    String hostAddress = inetAddress.getHostAddress();
                    boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return hostAddress;
                    }
                    if (isIPv4) continue;
                    int index = hostAddress.indexOf(37);
                    return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getLocalIp() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "0.0.0.0";
    }

    public static String getDomainAddress(String domain) {
        try {
            InetAddress inetAddress = InetAddress.getByName(domain);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnectServer(String path) {
        boolean isconnect = false;
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(path);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(20000);
            if (200 == urlConnection.getResponseCode()) {
                isconnect = true;
                return isconnect;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            return isconnect;
        }
    }

    public static boolean isNetConnected() {
        NetworkInfo[] infos;
        ConnectivityManager cm = (ConnectivityManager)HxFaceLibrary.getApp().getSystemService("connectivity");
        if (cm != null && (infos = cm.getAllNetworkInfo()) != null) {
            for (NetworkInfo ni : infos) {
                if (!ni.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean is3gConnected() {
        NetworkInfo networkInfo;
        ConnectivityManager cm = (ConnectivityManager)HxFaceLibrary.getApp().getSystemService("connectivity");
        return cm != null && (networkInfo = cm.getActiveNetworkInfo()) != null && networkInfo.getType() == 0;
    }

    public static enum NetworkType {
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

