/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public class GsonUtils {
    private static Gson mGson = new GsonBuilder().disableHtmlEscaping().create();
    private static Gson gsondisableHtml;

    public static Gson getGson() {
        return mGson;
    }

    public static <T> T fromJson(String json, Class<T> c) {
        return (T)mGson.fromJson(json, c);
    }

    public static <T> T fromJson(JsonElement json, Class<T> c) {
        return (T)mGson.fromJson(json, c);
    }

    public static <T> T fromJson(JsonElement json, Type type) {
        return (T)mGson.fromJson(json, type);
    }

    public static <T> T fromJson(String json, Type type) {
        return (T)mGson.fromJson(json, type);
    }

    public static String toJson(Object src) {
        return mGson.toJson(src);
    }

    public static Gson buildGsondisableHtmlEscaping() {
        if (gsondisableHtml == null) {
            gsondisableHtml = new GsonBuilder().registerTypeAdapter(Integer.class, (Object)new IntegerDefault0Adapter()).registerTypeAdapter(Integer.TYPE, (Object)new IntegerDefault0Adapter()).registerTypeAdapter(Double.class, (Object)new DoubleDefault0Adapter()).registerTypeAdapter(Double.TYPE, (Object)new DoubleDefault0Adapter()).registerTypeAdapter(Long.class, (Object)new LongDefault0Adapter()).registerTypeAdapter(Long.TYPE, (Object)new LongDefault0Adapter()).disableHtmlEscaping().create();
        }
        return gsondisableHtml;
    }

    private static class LongDefault0Adapter
    implements JsonSerializer<Long>,
    JsonDeserializer<Long> {
        private LongDefault0Adapter() {
        }

        public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                if (json.getAsString().equals("") || json.getAsString().equals("null")) {
                    return 0L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return json.getAsLong();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }

        public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src);
        }
    }

    private static class DoubleDefault0Adapter
    implements JsonSerializer<Double>,
    JsonDeserializer<Double> {
        private DoubleDefault0Adapter() {
        }

        public Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                if (json.getAsString().equals("") || json.getAsString().equals("null")) {
                    return 0.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return json.getAsDouble();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }

        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src);
        }
    }

    private static class IntegerDefault0Adapter
    implements JsonSerializer<Integer>,
    JsonDeserializer<Integer> {
        private IntegerDefault0Adapter() {
        }

        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                if (json.getAsString().equals("") || json.getAsString().equals("null")) {
                    return 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }

        public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src);
        }
    }
}

