/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.List;
import java.util.UUID;
import org.opencv.chinaredstar.HxFaceLibrary;
import org.opencv.chinaredstar.utils.DeviceUtils;
import org.opencv.chinaredstar.utils.NetUtils;
import org.opencv.chinaredstar.utils.PreferencesUtils;

public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    private static final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    public static final String MODEL_NUMBER = Build.MODEL;
    public static final String DISPLAY_NAME = Build.DISPLAY;
    public static final String OS_VERSION = Build.VERSION.RELEASE;
    public static final int SCREEN_WIDTH = DeviceInfo.getDisplayMetrics().widthPixels;
    public static final int SCREEN_HEIGHT = DeviceInfo.getDisplayMetrics().heightPixels;
    public static final String ACTIVITY_DTO_KEY = "ACTIVITY_DTO_KEY";
    private static long lastClickTime;

    public static DisplayMetrics getDisplayMetrics() {
        WindowManager windowMgr = (WindowManager)HxFaceLibrary.getApp().getSystemService("window");
        windowMgr.getDefaultDisplay().getMetrics(mDisplayMetrics);
        return mDisplayMetrics;
    }

    public static List<Camera.Size> getSupportedPreviewSizes(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List sizeList = parameters.getSupportedPreviewSizes();
        return sizeList;
    }

    public static long getRunTimes() {
        long ut = SystemClock.elapsedRealtime() / 1000L;
        if (ut == 0L) {
            ut = 1L;
        }
        return ut;
    }

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 500L) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static boolean isAppInstalled(Context context, String packageName) {
        boolean installed = false;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
            if (info != null) {
                installed = true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return installed;
    }

    public static boolean enoughSpaceOnPhone(long updateSize) {
        return DeviceInfo.getRealSizeOnPhone() > updateSize;
    }

    public static long getRealSizeOnPhone() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        long realSize = blockSize * availableBlocks;
        return realSize;
    }

    public static boolean enoughSpaceOnSdCard(long updateSize) {
        String status = Environment.getExternalStorageState();
        if (!status.equals("mounted")) {
            return false;
        }
        return updateSize < DeviceInfo.getRealSizeOnSdcard();
    }

    public static long getRealSizeOnSdcard() {
        File path = new File(Environment.getExternalStorageDirectory().getAbsolutePath());
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public static String getDeviceId() {
        String deviceId = null;
        if (ContextCompat.checkSelfPermission((Context)HxFaceLibrary.getApp(), (String)"android.permission.READ_PHONE_STATE") == 0) {
            deviceId = DeviceUtils.getDeviceId();
        }
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        deviceId = PreferencesUtils.getString("DeviceId");
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = DeviceInfo.gainUUID();
        }
        PreferencesUtils.putString("DeviceId", deviceId);
        return deviceId;
    }

    public static String gainUUID() {
        String strUUID = UUID.randomUUID().toString();
        strUUID = strUUID.replaceAll("-", "").toLowerCase();
        return strUUID;
    }

    public static String getIpAddress() {
        if (NetUtils.getIPAddress(true) == null) {
            return NetUtils.getLocalIp();
        }
        return NetUtils.getIPAddress(true);
    }

    public static String getMacAddressFromIp() {
        String mac_s = "02:00:00:00:00:00";
        StringBuilder buf = new StringBuilder();
        try {
            byte[] mac;
            NetworkInterface ne = NetworkInterface.getByInetAddress(InetAddress.getByName(DeviceInfo.getIpAddress()));
            for (byte b : mac = ne.getHardwareAddress()) {
                buf.append(String.format("%02X:", b));
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            mac_s = buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mac_s;
    }
}

