/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.service.mvp;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import com.lzy.okgo.model.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.opencv.chinaredstar.bean.HxRecommendBean;
import org.opencv.chinaredstar.bean.SearchFaceResultBean;
import org.opencv.chinaredstar.net.HttpUtils;
import org.opencv.chinaredstar.net.JsonCallback;
import org.opencv.chinaredstar.service.mvp.IsearchFaceView;
import org.opencv.chinaredstar.utils.DeviceInfo;

public class SearchFacePresenter {
    private String currentFaceId = "";
    private long time = 0L;
    private Context mContext;
    private IsearchFaceView mView;

    public SearchFacePresenter(Context context, IsearchFaceView view) {
        this.mContext = context;
        this.mView = view;
    }

    public void searchFace(final Bitmap bitmap, String imageFace) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mallId", (Object)"10062");
            jsonObject.put("deviceId", (Object)DeviceInfo.getDeviceId());
            jsonObject.put("macAddress", (Object)DeviceInfo.getMacAddressFromIp());
            jsonObject.put("ipAddress", (Object)DeviceInfo.getIpAddress());
            jsonObject.put("time", (Object)(System.currentTimeMillis() + ""));
            jsonObject.put("faceImage", (Object)imageFace);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Log.e((String)"params", (String)jsonObject.toString());
        HttpUtils.getInstance().post("", "https://api-aimall.mmall.com/basic/bigScreen/faceSearch", null, jsonObject.toString(), new JsonCallback<SearchFaceResultBean>(){

            public void onSuccess(Response<SearchFaceResultBean> response) {
                if (response.body() != null) {
                    SearchFaceResultBean body = (SearchFaceResultBean)response.body();
                    if (body.status == 200 && !TextUtils.isEmpty((CharSequence)body.value)) {
                        if (SearchFacePresenter.this.currentFaceId.equals(body.value) && body.timestamp - SearchFacePresenter.this.time < 2000L) {
                            SearchFacePresenter.this.mView.onCanSearch(true);
                        } else {
                            SearchFacePresenter.this.currentFaceId = body.value;
                            SearchFacePresenter.this.getRecommendAd(bitmap, body.value);
                        }
                    }
                }
            }

            public void onError(Response<SearchFaceResultBean> response) {
                super.onError(response);
                SearchFacePresenter.this.mView.onCanSearch(true);
            }

            public void onFinish() {
                super.onFinish();
                SearchFacePresenter.this.mView.onCanSearch(true);
            }
        });
    }

    public void getRecommendAd(final Bitmap bitmap, final String rsProfileId) {
        Log.e((String)"SearchFacePresenter", (String)"getRecommendAd");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mallId", (Object)"10062");
            jsonObject.put("deviceId", (Object)DeviceInfo.getDeviceId());
            jsonObject.put("macAddress", (Object)DeviceInfo.getMacAddressFromIp());
            jsonObject.put("ipAddress", (Object)DeviceInfo.getIpAddress());
            jsonObject.put("time", (Object)(System.currentTimeMillis() + ""));
            jsonObject.put("floor", 2);
            jsonObject.put("rsProfileId", (Object)rsProfileId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        HttpUtils.getInstance().post("", "https://api-aimall.mmall.com/basic/bigScreen/getRecommendAD", null, jsonObject.toString(), new JsonCallback<HxRecommendBean>(){

            public void onSuccess(Response<HxRecommendBean> response) {
                if (response.body() != null) {
                    HxRecommendBean body = (HxRecommendBean)response.body();
                    if (body.status == 200 && body.value != null) {
                        SearchFacePresenter.this.time = body.timestamp;
                        body.rsProfileId = rsProfileId;
                        SearchFacePresenter.this.mView.onSearchSuccess(bitmap, body);
                        return;
                    }
                }
                SearchFacePresenter.this.mView.onCanSearch(true);
                Log.e((String)"SearchFacePresenter", (String)response.message());
            }

            public void onError(Response<HxRecommendBean> response) {
                super.onError(response);
                SearchFacePresenter.this.mView.onCanSearch(true);
                Log.e((String)"SearchFace_onError", (String)response.message());
            }

            public void onFinish() {
                super.onFinish();
                SearchFacePresenter.this.mView.onCanSearch(true);
            }
        });
    }
}

