/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.opencv.R;
import org.opencv.android.BaseLoaderCallback;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.android.JavaCameraView;
import org.opencv.android.Utils;
import org.opencv.chinaredstar.bean.HxRecommendBean;
import org.opencv.chinaredstar.service.DetectionBasedTracker;
import org.opencv.chinaredstar.service.mvp.IsearchFaceView;
import org.opencv.chinaredstar.service.mvp.SearchFacePresenter;
import org.opencv.chinaredstar.utils.Base64BitmapUtil;
import org.opencv.chinaredstar.utils.DeviceInfo;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfRect;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.objdetect.CascadeClassifier;

public class HxFaceCaptureService
extends Service
implements CameraBridgeViewBase.CvCameraViewListener2 {
    private static final String TAG = "HxFaceCaptureService";
    private static final Scalar FACE_RECT_COLOR = new Scalar(0.0, 255.0, 0.0, 255.0);
    public static final int JAVA_DETECTOR = 0;
    public static final int NATIVE_DETECTOR = 1;
    private Mat mRgba;
    private Mat mGray;
    private Mat outPut;
    private Bitmap mBitmap;
    private File mCascadeFile;
    private CascadeClassifier mJavaDetector;
    private DetectionBasedTracker mNativeDetector;
    private JavaCameraView mOpenCvCameraView;
    private ImageView ivTest;
    private int mDetectorType = 0;
    private float mRelativeFaceSize = 0.2f;
    private int mAbsoluteFaceSize = 0;
    private WindowManager windowManager;
    private OnHxFaceDataCallBack mOnHxFaceDataCallBack;
    private Timer mTimer;
    private TimerTask mTask;
    private boolean mHasFace;
    private boolean mCanSearch = true;
    private Handler mHandler;
    private SearchFacePresenter mSarchFacePresenter;
    private WindowManager.LayoutParams mLayoutParams;
    private Mat mRotateMat;
    private Mat mRotateMat2;
    private Long time;
    private BaseLoaderCallback mLoaderCallback = new BaseLoaderCallback((Context)this){

        @Override
        public void onManagerConnected(int status) {
            switch (status) {
                case 0: {
                    Log.i((String)HxFaceCaptureService.TAG, (String)"OpenCV loaded successfully");
                    System.loadLibrary("detection_based_tracker");
                    try {
                        int bytesRead;
                        InputStream is = HxFaceCaptureService.this.getResources().openRawResource(R.raw.lbpcascade_frontalface);
                        File cascadeDir = HxFaceCaptureService.this.getDir("cascade", 0);
                        HxFaceCaptureService.this.mCascadeFile = new File(cascadeDir, "lbpcascade_frontalface.xml");
                        FileOutputStream os = new FileOutputStream(HxFaceCaptureService.this.mCascadeFile);
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = is.read(buffer)) != -1) {
                            os.write(buffer, 0, bytesRead);
                        }
                        is.close();
                        os.close();
                        HxFaceCaptureService.this.mJavaDetector = new CascadeClassifier(HxFaceCaptureService.this.mCascadeFile.getAbsolutePath());
                        if (HxFaceCaptureService.this.mJavaDetector.empty()) {
                            Log.e((String)HxFaceCaptureService.TAG, (String)"Failed to load cascade classifier");
                            HxFaceCaptureService.this.mJavaDetector = null;
                        } else {
                            Log.i((String)HxFaceCaptureService.TAG, (String)("Loaded cascade classifier from " + HxFaceCaptureService.this.mCascadeFile.getAbsolutePath()));
                        }
                        HxFaceCaptureService.this.mNativeDetector = new DetectionBasedTracker(HxFaceCaptureService.this.mCascadeFile.getAbsolutePath(), 0);
                        cascadeDir.delete();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Log.e((String)HxFaceCaptureService.TAG, (String)("Failed to load cascade. Exception thrown: " + e));
                    }
                    HxFaceCaptureService.this.mOpenCvCameraView.enableView();
                    break;
                }
                default: {
                    super.onManagerConnected(status);
                }
            }
        }
    };

    public HxFaceCaptureService() {
        Log.i((String)TAG, (String)("Instantiated new " + this.getClass()));
    }

    public IBinder onBind(Intent intent) {
        Log.e((String)TAG, (String)"onBind");
        return new HxFaceCaptureBinder();
    }

    public void onCreate() {
        super.onCreate();
        this.windowManager = (WindowManager)this.getSystemService("window");
        this.mOpenCvCameraView = new JavaCameraView((Context)this, 98);
        this.ivTest = new ImageView((Context)this);
        this.mLayoutParams = new WindowManager.LayoutParams(DeviceInfo.SCREEN_WIDTH, DeviceInfo.SCREEN_WIDTH, 2005, 262144, -3);
        this.mLayoutParams.gravity = 51;
        this.windowManager.addView((View)this.mOpenCvCameraView, (ViewGroup.LayoutParams)this.mLayoutParams);
        this.mOpenCvCameraView.setVisibility(0);
        this.mOpenCvCameraView.setPreviewSize(DeviceInfo.SCREEN_WIDTH, DeviceInfo.SCREEN_WIDTH);
        this.mOpenCvCameraView.setCvCameraViewListener(this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.initOpenCV();
        this.initTask();
        this.mSarchFacePresenter = new SearchFacePresenter((Context)this, new IsearchFaceView(){

            @Override
            public void onSearchSuccess(Bitmap bitmap, HxRecommendBean hxRecommendBean) {
                if (hxRecommendBean != null && HxFaceCaptureService.this.mOnHxFaceDataCallBack != null) {
                    HxFaceCaptureService.this.mOnHxFaceDataCallBack.HxFaceData(bitmap, hxRecommendBean);
                }
            }

            @Override
            public void onCanSearch(boolean canSearch) {
                HxFaceCaptureService.this.mCanSearch = canSearch;
            }
        });
        this.mHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                HxFaceCaptureService.this.mSarchFacePresenter.searchFace(HxFaceCaptureService.this.mBitmap, Base64BitmapUtil.bitmapToBase64(HxFaceCaptureService.this.mBitmap));
                return true;
            }
        });
        Log.e((String)TAG, (String)"onBind");
        return super.onStartCommand(intent, flags, startId);
    }

    private void initTask() {
        this.mTimer = new Timer();
        this.mTask = new TimerTask(){

            @Override
            public void run() {
                if (HxFaceCaptureService.this.mHasFace && HxFaceCaptureService.this.mBitmap != null && HxFaceCaptureService.this.mCanSearch) {
                    HxFaceCaptureService.this.mHandler.sendEmptyMessage(1);
                    HxFaceCaptureService.this.mCanSearch = false;
                    HxFaceCaptureService.this.mHasFace = false;
                    HxFaceCaptureService.this.time = System.currentTimeMillis();
                } else if (!HxFaceCaptureService.this.mCanSearch && System.currentTimeMillis() - HxFaceCaptureService.this.time > 5000L) {
                    HxFaceCaptureService.this.mCanSearch = true;
                }
            }
        };
    }

    private void initOpenCV() {
        Log.d((String)TAG, (String)"OpenCV library found inside package. Using it!");
        this.mLoaderCallback.onManagerConnected(0);
    }

    public boolean onUnbind(Intent intent) {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages((Object)this);
            this.mHandler = null;
        }
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mOpenCvCameraView != null) {
            this.mOpenCvCameraView.disableView();
        }
    }

    @Override
    public void onCameraViewStarted(int width, int height) {
        this.mGray = new Mat();
        this.mRgba = new Mat();
        this.mTimer.schedule(this.mTask, 0L, 2000L);
    }

    @Override
    public void onCameraViewStopped() {
        this.mGray.release();
        this.mRgba.release();
        if (this.mRotateMat != null) {
            this.mRotateMat.release();
        }
        if (this.mRotateMat2 != null) {
            this.mRotateMat2.release();
        }
        if (this.outPut != null) {
            this.outPut.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mat onCameraFrame(CameraBridgeViewBase.CvCameraViewFrame inputFrame) {
        HxFaceCaptureService hxFaceCaptureService = this;
        synchronized (hxFaceCaptureService) {
            Rect[] facesArray;
            this.mRgba = inputFrame.rgba();
            this.mGray = inputFrame.gray();
            if (this.mAbsoluteFaceSize == 0) {
                int height = this.mGray.rows();
                if (Math.round((float)height * this.mRelativeFaceSize) > 0) {
                    this.mAbsoluteFaceSize = Math.round((float)height * this.mRelativeFaceSize);
                }
                this.mNativeDetector.setMinFaceSize(this.mAbsoluteFaceSize);
            }
            MatOfRect faces = new MatOfRect();
            this.mRotateMat = Imgproc.getRotationMatrix2D(new Point(this.mGray.rows() / 2, this.mGray.cols() / 2), this.getPreviewRotateDegree(), 1.0);
            this.mRotateMat2 = Imgproc.getRotationMatrix2D(new Point(this.mRgba.rows() / 2, this.mRgba.cols() / 2), this.getPreviewRotateDegree(), 1.0);
            Imgproc.warpAffine(this.mGray, this.mGray, this.mRotateMat, this.mGray.size());
            Imgproc.warpAffine(this.mRgba, this.mRgba, this.mRotateMat2, this.mRgba.size());
            if (this.mDetectorType == 0) {
                if (this.mJavaDetector != null) {
                    this.mJavaDetector.detectMultiScale(this.mRgba, faces, 1.1, 6, 0, new Size(this.mAbsoluteFaceSize, this.mAbsoluteFaceSize), new Size());
                }
            } else if (this.mDetectorType == 1 && this.mNativeDetector != null) {
                this.mNativeDetector.detect(this.mGray, faces);
            }
            if ((facesArray = faces.toArray()).length > 0) {
                Imgproc.rectangle(this.mRgba, facesArray[0].tl(), facesArray[0].br(), FACE_RECT_COLOR, 3);
                if (this.mCanSearch) {
                    this.outPut = new Mat(this.mRgba, facesArray[0]);
                    this.mBitmap = Bitmap.createBitmap((int)this.outPut.cols(), (int)this.outPut.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Utils.matToBitmap(this.outPut, this.mBitmap);
                    this.mHasFace = true;
                }
            }
        }
        return this.mRgba;
    }

    private int getPreviewRotateDegree() {
        int phoneDegree = 0;
        int result = 0;
        int phoneRotate = this.windowManager.getDefaultDisplay().getOrientation();
        switch (phoneRotate) {
            case 0: {
                phoneDegree = 0;
                break;
            }
            case 1: {
                phoneDegree = 90;
                break;
            }
            case 2: {
                phoneDegree = 180;
                break;
            }
            case 3: {
                phoneDegree = 270;
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        if (this.mOpenCvCameraView != null && !this.mOpenCvCameraView.IsBackCamera()) {
            Core.flip(this.mRgba, this.mRgba, 0);
            Core.flip(this.mGray, this.mGray, 0);
            Camera.getCameraInfo((int)1, (Camera.CameraInfo)cameraInfo);
            result = (cameraInfo.orientation + phoneDegree) % 360;
            result = (360 - result) % 360;
            Log.d((String)TAG, (String)("front_degree" + result));
        } else {
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
            result = 360 - (cameraInfo.orientation - phoneDegree + 360) % 360;
            Log.d((String)TAG, (String)("back_degree" + result));
        }
        return result;
    }

    public void setOnHxFaceDataCallBack(OnHxFaceDataCallBack callBack) {
        this.mOnHxFaceDataCallBack = callBack;
    }

    public class HxFaceCaptureBinder
    extends Binder {
        public HxFaceCaptureService getService() {
            return HxFaceCaptureService.this;
        }
    }

    public static interface OnHxFaceDataCallBack {
        public void HxFaceData(Bitmap var1, HxRecommendBean var2);
    }
}

