/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.cache.CacheMode;
import com.lzy.okgo.cookie.CookieJarImpl;
import com.lzy.okgo.cookie.store.CookieStore;
import com.lzy.okgo.cookie.store.DBCookieStore;
import com.lzy.okgo.https.HttpsUtils;
import com.lzy.okgo.interceptor.HttpLoggingInterceptor;
import com.lzy.okgo.model.HttpHeaders;
import com.lzy.okgo.model.HttpParams;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HxFaceLibrary {
    @SuppressLint(value={"StaticFieldLeak"})
    public static Application mApplication;

    public static void init(Application context) {
        mApplication = context;
        HxFaceLibrary.initHttp(context);
    }

    private static void initHttp(Application context) {
        HttpHeaders headers = new HttpHeaders();
        HttpParams params = new HttpParams();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor("OkGo");
        loggingInterceptor.setPrintLevel(HttpLoggingInterceptor.Level.BODY);
        loggingInterceptor.setColorLevel(Level.INFO);
        builder.addInterceptor((Interceptor)loggingInterceptor);
        builder.readTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.connectTimeout(60000L, TimeUnit.MILLISECONDS);
        builder.cookieJar((CookieJar)new CookieJarImpl((CookieStore)new DBCookieStore((Context)context)));
        HttpsUtils.SSLParams sslParams1 = HttpsUtils.getSslSocketFactory();
        builder.sslSocketFactory(sslParams1.sSLSocketFactory, sslParams1.trustManager);
        OkGo.getInstance().init(context).setOkHttpClient(builder.build()).setCacheMode(CacheMode.NO_CACHE).setCacheTime(-1L).setRetryCount(3).addCommonHeaders(headers).addCommonParams(params);
    }

    public static Application getApp() {
        if (mApplication != null) {
            return mApplication;
        }
        throw new NullPointerException("u should init first");
    }
}

