/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

@TargetApi(value=21)
public class JavaCamera2View
extends CameraBridgeViewBase {
    private static final String LOGTAG = "JavaCamera2View";
    private ImageReader mImageReader;
    private int mPreviewFormat = 35;
    private CameraDevice mCameraDevice;
    private CameraCaptureSession mCaptureSession;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private String mCameraID;
    private Size mPreviewSize = new Size(-1, -1);
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            JavaCamera2View.this.mCameraDevice = cameraDevice;
            JavaCamera2View.this.createCameraPreviewSession();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            JavaCamera2View.this.mCameraDevice = null;
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            JavaCamera2View.this.mCameraDevice = null;
        }
    };

    public JavaCamera2View(Context context, int cameraId) {
        super(context, cameraId);
    }

    public JavaCamera2View(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private void startBackgroundThread() {
        Log.i((String)LOGTAG, (String)"startBackgroundThread");
        this.stopBackgroundThread();
        this.mBackgroundThread = new HandlerThread("OpenCVCameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        Log.i((String)LOGTAG, (String)"stopBackgroundThread");
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"stopBackgroundThread", (Throwable)e);
        }
    }

    protected boolean initializeCamera() {
        Log.i((String)LOGTAG, (String)"initializeCamera");
        CameraManager manager = (CameraManager)this.getContext().getSystemService("camera");
        try {
            String[] camList = manager.getCameraIdList();
            if (camList.length == 0) {
                Log.e((String)LOGTAG, (String)"Error: camera isn't detected.");
                return false;
            }
            if (this.mCameraIndex == -1) {
                this.mCameraID = camList[0];
            } else {
                for (String cameraID : camList) {
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraID);
                    if ((this.mCameraIndex != 99 || (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != 1) && (this.mCameraIndex != 98 || (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != 0)) continue;
                    this.mCameraID = cameraID;
                    break;
                }
            }
            if (this.mCameraID != null) {
                Log.i((String)LOGTAG, (String)("Opening camera: " + this.mCameraID));
                manager.openCamera(this.mCameraID, this.mStateCallback, this.mBackgroundHandler);
            }
            return true;
        }
        catch (CameraAccessException e) {
            Log.e((String)LOGTAG, (String)"OpenCamera - Camera Access Exception", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOGTAG, (String)"OpenCamera - Illegal Argument Exception", (Throwable)e);
        }
        catch (SecurityException e) {
            Log.e((String)LOGTAG, (String)"OpenCamera - Security Exception", (Throwable)e);
        }
        return false;
    }

    private void createCameraPreviewSession() {
        final int w = this.mPreviewSize.getWidth();
        final int h = this.mPreviewSize.getHeight();
        Log.i((String)LOGTAG, (String)("createCameraPreviewSession(" + w + "x" + h + ")"));
        if (w < 0 || h < 0) {
            return;
        }
        try {
            if (null == this.mCameraDevice) {
                Log.e((String)LOGTAG, (String)"createCameraPreviewSession: camera isn't opened");
                return;
            }
            if (null != this.mCaptureSession) {
                Log.e((String)LOGTAG, (String)"createCameraPreviewSession: mCaptureSession is already started");
                return;
            }
            this.mImageReader = ImageReader.newInstance((int)w, (int)h, (int)this.mPreviewFormat, (int)2);
            this.mImageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){

                public void onImageAvailable(ImageReader reader) {
                    Image image = reader.acquireLatestImage();
                    if (image == null) {
                        return;
                    }
                    Image.Plane[] planes = image.getPlanes();
                    assert (planes.length == 3);
                    assert (image.getFormat() == JavaCamera2View.this.mPreviewFormat);
                    assert (planes[0].getPixelStride() == 1);
                    assert (planes[1].getPixelStride() == 2);
                    assert (planes[2].getPixelStride() == 2);
                    ByteBuffer y_plane = planes[0].getBuffer();
                    ByteBuffer uv_plane = planes[1].getBuffer();
                    Mat y_mat = new Mat(h, w, CvType.CV_8UC1, y_plane);
                    Mat uv_mat = new Mat(h / 2, w / 2, CvType.CV_8UC2, uv_plane);
                    JavaCamera2Frame tempFrame = new JavaCamera2Frame(y_mat, uv_mat, w, h);
                    JavaCamera2View.this.deliverAndDrawFrame(tempFrame);
                    tempFrame.release();
                    image.close();
                }
            }, this.mBackgroundHandler);
            Surface surface = this.mImageReader.getSurface();
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            this.mCameraDevice.createCaptureSession(Arrays.asList(surface), new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    Log.i((String)JavaCamera2View.LOGTAG, (String)"createCaptureSession::onConfigured");
                    if (null == JavaCamera2View.this.mCameraDevice) {
                        return;
                    }
                    JavaCamera2View.this.mCaptureSession = cameraCaptureSession;
                    try {
                        JavaCamera2View.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        JavaCamera2View.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                        JavaCamera2View.this.mCaptureSession.setRepeatingRequest(JavaCamera2View.this.mPreviewRequestBuilder.build(), null, JavaCamera2View.this.mBackgroundHandler);
                        Log.i((String)JavaCamera2View.LOGTAG, (String)"CameraPreviewSession has been started");
                    }
                    catch (Exception e) {
                        Log.e((String)JavaCamera2View.LOGTAG, (String)"createCaptureSession failed", (Throwable)e);
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)JavaCamera2View.LOGTAG, (String)"createCameraPreviewSession failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)LOGTAG, (String)"createCameraPreviewSession", (Throwable)e);
        }
    }

    @Override
    protected void disconnectCamera() {
        Log.i((String)LOGTAG, (String)"closeCamera");
        try {
            CameraDevice c = this.mCameraDevice;
            this.mCameraDevice = null;
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != c) {
                c.close();
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        finally {
            this.stopBackgroundThread();
        }
    }

    boolean calcPreviewSize(int width, int height) {
        Log.i((String)LOGTAG, (String)("calcPreviewSize: " + width + "x" + height));
        if (this.mCameraID == null) {
            Log.e((String)LOGTAG, (String)"Camera isn't initialized!");
            return false;
        }
        CameraManager manager = (CameraManager)this.getContext().getSystemService("camera");
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.mCameraID);
            StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            int bestWidth = 0;
            int bestHeight = 0;
            float aspect = (float)width / (float)height;
            Size[] sizes = map.getOutputSizes(ImageReader.class);
            bestWidth = sizes[0].getWidth();
            bestHeight = sizes[0].getHeight();
            for (Size sz : sizes) {
                int w = sz.getWidth();
                int h = sz.getHeight();
                Log.d((String)LOGTAG, (String)("trying size: " + w + "x" + h));
                if (width < w || height < h || bestWidth > w || bestHeight > h || !((double)Math.abs(aspect - (float)w / (float)h) < 0.2)) continue;
                bestWidth = w;
                bestHeight = h;
            }
            Log.i((String)LOGTAG, (String)("best size: " + bestWidth + "x" + bestHeight));
            assert (bestWidth != 0 && bestHeight != 0);
            if (this.mPreviewSize.getWidth() == bestWidth && this.mPreviewSize.getHeight() == bestHeight) {
                return false;
            }
            this.mPreviewSize = new Size(bestWidth, bestHeight);
            return true;
        }
        catch (CameraAccessException e) {
            Log.e((String)LOGTAG, (String)"calcPreviewSize - Camera Access Exception", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOGTAG, (String)"calcPreviewSize - Illegal Argument Exception", (Throwable)e);
        }
        catch (SecurityException e) {
            Log.e((String)LOGTAG, (String)"calcPreviewSize - Security Exception", (Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean connectCamera(int width, int height) {
        Log.i((String)LOGTAG, (String)("setCameraPreviewSize(" + width + "x" + height + ")"));
        this.startBackgroundThread();
        this.initializeCamera();
        try {
            boolean needReconfig = this.calcPreviewSize(width, height);
            this.mFrameWidth = this.mPreviewSize.getWidth();
            this.mFrameHeight = this.mPreviewSize.getHeight();
            this.mScale = this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1 ? Math.min((float)height / (float)this.mFrameHeight, (float)width / (float)this.mFrameWidth) : 0.0f;
            this.AllocateCache();
            if (needReconfig) {
                if (null != this.mCaptureSession) {
                    Log.d((String)LOGTAG, (String)"closing existing previewSession");
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                this.createCameraPreviewSession();
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Interrupted while setCameraPreviewSize.", e);
        }
        return true;
    }

    private class JavaCamera2Frame
    implements CameraBridgeViewBase.CvCameraViewFrame {
        private Mat mYuvFrameData;
        private Mat mUVFrameData;
        private Mat mRgba;
        private int mWidth;
        private int mHeight;

        @Override
        public Mat gray() {
            return this.mYuvFrameData.submat(0, this.mHeight, 0, this.mWidth);
        }

        @Override
        public Mat rgba() {
            if (JavaCamera2View.this.mPreviewFormat == 17) {
                Imgproc.cvtColor(this.mYuvFrameData, this.mRgba, 96, 4);
            } else if (JavaCamera2View.this.mPreviewFormat == 842094169) {
                Imgproc.cvtColor(this.mYuvFrameData, this.mRgba, 100, 4);
            } else if (JavaCamera2View.this.mPreviewFormat == 35) {
                assert (this.mUVFrameData != null);
                Imgproc.cvtColorTwoPlane(this.mYuvFrameData, this.mUVFrameData, this.mRgba, 96);
            } else {
                throw new IllegalArgumentException("Preview Format can be NV21 or YV12");
            }
            return this.mRgba;
        }

        public JavaCamera2Frame(Mat Yuv420sp, int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            this.mYuvFrameData = Yuv420sp;
            this.mUVFrameData = null;
            this.mRgba = new Mat();
        }

        public JavaCamera2Frame(Mat Y, Mat UV, int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            this.mYuvFrameData = Y;
            this.mUVFrameData = UV;
            this.mRgba = new Mat();
        }

        public void release() {
            this.mRgba.release();
        }
    }
}

