package org.opencv.chinaredstar.utils;

import android.Manifest;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;

import org.opencv.chinaredstar.HxFaceLibrary;
import org.opencv.chinaredstar.constants.FaceLibraryContants;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.List;
import java.util.UUID;

/**
 * Created by Wisn on 2018/8/10 下午7:09.
 */
public class DeviceInfo {

    /***Log输出标识**/
    private static final String TAG = "DeviceInfo";

    /***屏幕显示材质**/
    private static final DisplayMetrics mDisplayMetrics = new DisplayMetrics();

    /**
     * 操作系统名称(GT-I9100G)
     ***/
    public static final String MODEL_NUMBER = Build.MODEL;

    /**
     * 操作系统名称(I9100G)
     ***/
    public static final String DISPLAY_NAME = Build.DISPLAY;

    /**
     * 操作系统版本(4.4)
     ***/
    public static final String OS_VERSION = Build.VERSION.RELEASE;


    /***屏幕宽度**/
    public static final int SCREEN_WIDTH = getDisplayMetrics().widthPixels;

    /***屏幕高度**/
    public static final int SCREEN_HEIGHT = getDisplayMetrics().heightPixels;


    /***Activity之间数据传输数据对象Key**/
    public static final String ACTIVITY_DTO_KEY = "ACTIVITY_DTO_KEY";

    /**
     * 获取系统显示材质
     ***/
    public static DisplayMetrics getDisplayMetrics() {
        WindowManager windowMgr = (WindowManager) HxFaceLibrary.getApp().getSystemService(Context.WINDOW_SERVICE);
        windowMgr.getDefaultDisplay().getMetrics(mDisplayMetrics);
        return mDisplayMetrics;
    }

    /**
     * 获取摄像头支持的分辨率
     ***/
    public static List<Camera.Size> getSupportedPreviewSizes(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List<Camera.Size> sizeList = parameters.getSupportedPreviewSizes();
        return sizeList;
    }


    /**
     * 获取运行时间
     *
     * @return 运行时间(单位 / s)
     */
    public static long getRunTimes() {
        long ut = SystemClock.elapsedRealtime() / 1000;
        if (ut == 0) {
            ut = 1;
        }
        return ut;
    }

    /**
     * 按钮连续点击（500毫秒内不能同时起效）
     */
    private static long lastClickTime;

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        if (time - lastClickTime < 500) {
            return true;
        }
        lastClickTime = time;
        return false;
    }

    /**
     * 检查apk是否已经安装
     *
     * @param context
     * @param packageName
     */
    public static boolean isAppInstalled(Context context, String packageName) {
        boolean installed = false;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
            if (info != null) installed = true;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return installed;
    }

    /**
     * Checks if there is enough Space on phone self
     */
    public static boolean enoughSpaceOnPhone(long updateSize) {
        return getRealSizeOnPhone() > updateSize;
    }

    /**
     * get the space is left over on phone self
     */
    public static long getRealSizeOnPhone() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        long realSize = blockSize * availableBlocks;
        return realSize;
    }

    /**
     * Checks if there is enough Space on SDCard
     *
     * @param updateSize Size to Check
     * @return True if the Update will fit on SDCard, false if not enough space on SDCard Will also return false, if the SDCard is
     * not mounted as read/write
     */
    public static boolean enoughSpaceOnSdCard(long updateSize) {
        String status = Environment.getExternalStorageState();
        if (!status.equals(Environment.MEDIA_MOUNTED))
            return false;
        return (updateSize < getRealSizeOnSdcard());
    }

    /**
     * get the space is left over on sdcard
     */
    public static long getRealSizeOnSdcard() {
        File path = new File(Environment.getExternalStorageDirectory().getAbsolutePath());
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }


    /**
     * 获取deviceid，如果没有权限会生成一个uuid（不清空存储的情况下会保持唯一），每次都尝试去获取真实的id
     *
     * @return
     */
    public static String getDeviceId() {
        String deviceId = null;
        if (ContextCompat.checkSelfPermission(HxFaceLibrary.getApp(),
                Manifest.permission.READ_PHONE_STATE)
                == PackageManager.PERMISSION_GRANTED) {
            deviceId = DeviceUtils.getDeviceId();
        }
        if (!TextUtils.isEmpty(deviceId)) {
            return deviceId;
        }
        deviceId = PreferencesUtils.getString(FaceLibraryContants.DeviceId);
        if (TextUtils.isEmpty(deviceId)) {
            deviceId = gainUUID();
        }
        PreferencesUtils.putString(FaceLibraryContants.DeviceId, deviceId);
        return deviceId;
    }

    public static String gainUUID() {
        String strUUID = UUID.randomUUID().toString();
        strUUID = strUUID.replaceAll("-", "").toLowerCase();
        return strUUID;
    }


    /*获取IP地址*/
    public static String getIpAddress() {
        if (NetUtils.getIPAddress(true) == null) {
            return NetUtils.getLocalIp();
        }
        return NetUtils.getIPAddress(true);
    }

    /*获取mac地址*/
    public static String getMacAddressFromIp() {
        String mac_s= "02:00:00:00:00:00";
        StringBuilder buf = new StringBuilder();
        try {
            byte[] mac;
            NetworkInterface ne=NetworkInterface.getByInetAddress(InetAddress.getByName(getIpAddress()));
            mac = ne.getHardwareAddress();
            for (byte b : mac) {
                buf.append(String.format("%02X:", b));
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            mac_s = buf.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return mac_s;
    }






}
