/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.chinaredstar.net;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.lang.reflect.Type;
import org.opencv.chinaredstar.net.JsonConvertor;

public class Convert {
    private static Gson create() {
        return GsonHolder.gson;
    }

    public static <T> T fromJson(String json, Class<T> type) throws JsonIOException, JsonSyntaxException {
        return (T)Convert.create().fromJson(json, type);
    }

    public static <T> T fromJson(String json, Type type) {
        return (T)Convert.create().fromJson(json, type);
    }

    public static <T> T fromJson(JsonReader reader, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)Convert.create().fromJson(reader, typeOfT);
    }

    public static <T> T fromJson(Reader json, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)Convert.create().fromJson(json, classOfT);
    }

    public static <T> T fromJson(Reader json, Type typeOfT) throws JsonIOException, JsonSyntaxException {
        return (T)Convert.create().fromJson(json, typeOfT);
    }

    public static String toJson(Object src) {
        return Convert.create().toJson(src);
    }

    public static String toJson(Object src, Type typeOfSrc) {
        return Convert.create().toJson(src, typeOfSrc);
    }

    public static String formatJson(String json) {
        try {
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(json);
            return JsonConvertor.getInstance().toJson(je);
        }
        catch (Exception e) {
            return json;
        }
    }

    public static String formatJson(Object src) {
        try {
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(Convert.toJson(src));
            return JsonConvertor.getInstance().toJson(je);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static class GsonHolder {
        private static Gson gson = new Gson();

        private GsonHolder() {
        }
    }
}

