package com.chinapex.android.monitor;

import android.content.Context;
import android.view.View;

import com.chinapex.android.monitor.callback.IMonitorCallback;
import com.chinapex.android.monitor.utils.MLog;

import java.util.Map;
import java.util.Stack;

/**
 * @author SteelCabbage
 * @date 2018/12/14
 */
public class MonitorTools {

    private static final String TAG = MonitorTools.class.getSimpleName();

    /**
     * 开启悬浮窗
     *
     * @param context          Application的上下文
     * @param iMonitorCallback 圈选模式的回调
     * @param top              指向栈顶Activity顶指针
     */
    public static void showFloatingWindow(Context context, IMonitorCallback iMonitorCallback,
                                          Map<Integer, Stack<Map<String, Boolean>>> tasks,
                                          Map<Integer, Integer> top, int[] foregroundTask) {
        MLog.d(TAG, "showFloatingWindow: NO OP!");
    }

    /**
     * 关闭悬浮窗，比如回到桌面
     */
    public static void dismissFloatingWindow() {
        MLog.d(TAG, "dismissFloatingWindow: NO OP!!");
    }

    /**
     * 显示点击事件定义页面
     *
     * @param view      点击的视图控件
     * @param viewPath  控件路径
     * @param pageClass 页面路径
     */
    public static void showClickDefinePage(View view, String viewPath, String pageClass, String findPath) {
        MLog.d(TAG, "showClickDefinePage: NO OP!");
    }

    /**
     * 显示列表点击事件的定义页面
     *
     * @param view      列表某一项的视图控件
     * @param viewPath  控件路径
     * @param pageClass 页面路径
     * @param itemPath  列表条目路径
     * @param findPath  查找控件的路径
     * @param listType  列表点击事件的列表类型
     */
    public static void showListItemClickDefinePage(View view, String viewPath, String pageClass, String itemPath, String findPath, int listType) {
        MLog.d(TAG, "showListItemClickDefinePage: NO OP!");
    }

    /**
     * 选择点击项进行对比
     *
     * @param viewPath 点击项的view path
     */
    public static boolean addContrastItem(String viewPath, String pageClassName) {
        MLog.d(TAG, "addContrastItem: NO OP!");
        return false;
    }

    /**
     * Monitor的服务器域名过滤(同时设置Monitor)
     *
     * @param hostnameVerifier 服务器域名过滤
     */
    public static void setHostnameVerifier(String hostnameVerifier) {
        MLog.d(TAG, "setHostnameVerifier: NO OP!");
    }

    /**
     * 设置Monitor的服务器地址
     *
     * @param serverRoot 服务器地址
     */
    public static void setServerRoot(String serverRoot) {
        MLog.d(TAG, "setServerRoot: NO OP!");
    }
}
