package com.chinapex.android.monitor.view.upload;

import android.text.TextUtils;

import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.bean.response.CommonResponse;
import com.chinapex.android.monitor.callback.IWriteConfigToSpCallback;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.executor.runnable.IUpdateUI;
import com.chinapex.android.monitor.executor.runnable.UploadSnapshots;
import com.chinapex.android.monitor.executor.runnable.WriteConfigToSp;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;

import java.util.List;

/**
 * @author wyhusky
 * @date 2019/1/17
 */
public class UploadViewPresenter implements UploadViewContract.Presenter, IWriteConfigToSpCallback, IUpdateUI {

    private static final String TAG = UploadViewPresenter.class.getSimpleName();
    private UploadViewContract.View mUploadView;
    private boolean isUploadConfigSuccess, isUploadSnapshotSuccess;


    public UploadViewPresenter(UploadViewContract.View view) {
        this.mUploadView = view;
    }

    @Override
    public void init() {

    }

    @Override
    public void upload(List<UploadViewBean> uploadViewBeans) {
        mUploadView.showUploading();
        TaskController.getInstance().submit(new WriteConfigToSp(this));
        TaskController.getInstance().submit(new UploadSnapshots(uploadViewBeans, this));
    }

    @Override
    public void writeConfigToSp(final boolean isSuccessful) {
        isUploadConfigSuccess = isSuccessful;
        if (!isSuccessful) {
            TaskController.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mUploadView.showUploadFailed();
                }
            });
            return;
        }
        result();
    }

    @Override
    public void updateUI(boolean isSuccess, String result) {
        if (!isSuccess) {
            TaskController.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mUploadView.showUploadFailed();
                }
            });
            isUploadSnapshotSuccess = false;
            return;
        }

        CommonResponse response = GsonUtils.json2Bean(result, CommonResponse.class);
        if (null == response) {
            MLog.e(TAG, "updateUI()-> response is null!");
            TaskController.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mUploadView.showUploadFailed();
                }
            });
            isUploadSnapshotSuccess = false;
            return;
        }

        int status = response.getStatus();
        isUploadSnapshotSuccess = response.isData();
        if (Constant.RESPONSE_OK != status || !isUploadSnapshotSuccess) {
            MLog.e(TAG, "updateUI()-> error: status is " + status + ", data=" + isUploadSnapshotSuccess);
            TaskController.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mUploadView.showUploadFailed();
                }
            });
            return;
        }

        result();
    }

    private void result() {
        if (isUploadSnapshotSuccess && isUploadConfigSuccess) {
            TaskController.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mUploadView.showUploadSuccess();
                }
            });
            isUploadConfigSuccess = false;
            isUploadSnapshotSuccess = false;
        }
    }
}
