package com.chinapex.android.monitor.view.statistics;

import com.chinapex.android.monitor.view.BasePresenter;
import com.chinapex.android.monitor.view.BaseView;

/**
 * @author wyhusky
 * @date 2019/1/17
 */
interface StatisticsViewContract {
    interface View extends BaseView {
        /**
         * 更新列表、饼图、表格
         */
        void refreshViews();

        /**
         * 显示无对比数据时的UI
         */
        void showEmptyView();
    }

    interface Presenter extends BasePresenter {
        /**
         * 加载对比数据
         */
        void loadContrastData();

        /**
         * 清空对比项
         */
        void clearContrastItems();

        /**
         * 删除某一项对比项
         *
         * @param position position
         */
        void deleteContrastItem(int position);
    }
}
