package com.chinapex.android.monitor.view.statistics;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ListView;

/**
 * @author Seven Qiu
 * @date 2019-07-22
 */
public class ColumnListView extends ListView {
    public ColumnListView(Context context) {
        super(context);
    }

    public ColumnListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ColumnListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /**
     * 重写该方法，达到使ListView适应ScrollView的效果
     */
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = MeasureSpec.makeMeasureSpec(Integer.MAX_VALUE >> 2,
                MeasureSpec.AT_MOST);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }
}
