package com.chinapex.android.monitor.view.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.BitmapStorageUtil;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.IFloatingView;
import com.chinapex.android.monitor.view.snapshot.SnapshotView;

import java.util.List;

/**
 * @author : Seven
 * @date : 2019/1/8
 */
public class UploadListAdapter extends BaseExpandableListAdapter implements View.OnClickListener {

    private static final String TAG = UploadListAdapter.class.getSimpleName();

    private List<UploadViewBean> mUploadViewBeans;
    private OnItemClickListener mOnItemClickListener;

    public UploadListAdapter(List<UploadViewBean> uploadViewBeans) {
        mUploadViewBeans = uploadViewBeans;
    }

    /**
     * 条目点击监听器
     */
    public interface OnItemClickListener {
        /**
         * 条目点击回调方法
         *
         * @param position position
         */
        void onItemClick(int position);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    @Override
    public int getGroupCount() {
        return null == mUploadViewBeans ? 0 : mUploadViewBeans.size();
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        return 1;
    }

    @Override
    public Object getGroup(int groupPosition) {
        return mUploadViewBeans.get(groupPosition);
    }

    @Override
    public Object getChild(int groupPosition, int childPosition) {
        return childPosition;
    }

    @Override
    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @Override
    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    @Override
    public boolean hasStableIds() {
        return false;
    }

    @Override
    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Override
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupViewHolder groupViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.upload_event_list_item_group, parent, false);
            groupViewHolder = new GroupViewHolder(convertView);
            convertView.setTag(groupViewHolder);
        } else {
            groupViewHolder = (GroupViewHolder) convertView.getTag();
        }

        if (null == mUploadViewBeans) {
            MLog.e(TAG, "getGroupView() -> mUploadViewBeans is null !");
            return convertView;
        }

        UploadViewBean uploadViewBean = mUploadViewBeans.get(groupPosition);
        if (null == uploadViewBean) {
            MLog.e(TAG, "getGroupView() -> uploadViewBean is null !");
            return convertView;
        }

        groupViewHolder.eventSequence.setText(String.valueOf(groupPosition));
        groupViewHolder.eventName.setText(uploadViewBean.getAlias());
        groupViewHolder.btnDeleteItem.setTag(groupPosition);

        groupViewHolder.btnDeleteItem.setOnClickListener(this);

        return convertView;
    }

    @Override
    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ChildViewHolder childViewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext()).inflate(R.layout.upload_event_list_item_child, parent, false);
            childViewHolder = new ChildViewHolder(convertView);
            convertView.setTag(childViewHolder);
        } else {
            childViewHolder = (ChildViewHolder) convertView.getTag();
        }

        if (null == mUploadViewBeans) {
            MLog.e(TAG, "getChildView() -> mUploadViewBeans is null !");
            return convertView;
        }

        UploadViewBean uploadViewBean = mUploadViewBeans.get(groupPosition);
        if (null == uploadViewBean) {
            MLog.e(TAG, "getChildView() -> uploadViewBean is null !");
            return convertView;
        }

        final String snapshotPath;
        if (BitmapStorageUtil.isBitmapExist(uploadViewBean.getMd5())) {
            snapshotPath = BitmapStorageUtil.getBitmapStoragePath(uploadViewBean.getMd5());
        } else {
            snapshotPath = MonitorCache.getInstance().getServerRoot() + Constant.URL_DOWN_SANPSHOT
                    + "?md5=" + uploadViewBean.getMd5() + "&terminal=" + Constant.TERMINAL;
        }
        Glide.with(parent).load(snapshotPath).centerInside().into(childViewHolder.thumbnail);
        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FloatingViewManager.getInstance().showFloatingView(IFloatingView.WINDOW_SNAPSHOT);
                SnapshotView sv = (SnapshotView) FloatingViewManager.getInstance().getFloatingView(IFloatingView.WINDOW_SNAPSHOT);
                sv.loadImage(snapshotPath);
            }
        });
        return convertView;

    }

    @Override
    public void onClick(View v) {
        if (null == mOnItemClickListener) {
            MLog.e(TAG, "mOnItemClickListener is null!");
            return;
        }

        int tag = (Integer) v.getTag();
        mOnItemClickListener.onItemClick(tag);
        notifyDataSetChanged();
    }

    class GroupViewHolder {

        TextView eventSequence;
        TextView eventName;
        TextView btnDeleteItem;

        public GroupViewHolder(View itemView) {
            eventSequence = itemView.findViewById(R.id.tv_upload_sequence);
            eventName = itemView.findViewById(R.id.tv_upload_event_name);
            btnDeleteItem = itemView.findViewById(R.id.tv_delete_upload_item);
        }

    }

    class ChildViewHolder {
        ImageView thumbnail;

        public ChildViewHolder(View itemView) {
            thumbnail = itemView.findViewById(R.id.iv_thumbnail_upload);
        }
    }
}
