package com.chinapex.android.monitor.view.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.TextView;

import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ImportConfigBean;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.utils.MLog;

import java.util.List;

/**
 * @author wyhusky
 * @date 2019/1/28
 */
public class ConfigRvAdapter extends RecyclerView.Adapter<ConfigRvAdapter.ConfigRvHolder> implements View.OnClickListener {

    private static final String TAG = ConfigRvAdapter.class.getSimpleName();

    private OnItemClickListener mOnItemClickListener;
    private List<ImportConfigBean> mVersions;

    /**
     * RecyclerView 条目点击监听器
     */
    public interface OnItemClickListener {
        /**
         * RecyclerView 条目点击回调方法
         *
         * @param position position
         */
        void onItemClick(int position);
    }

    public ConfigRvAdapter(List<ImportConfigBean> versions) {
        mVersions = versions;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    @Override
    public void onClick(View v) {
        if (null == mOnItemClickListener) {
            MLog.e(TAG, "mOnItemClickListener is null!");
            return;
        }

        Integer position = (Integer) v.getTag();

        for (int i = 0; i < mVersions.size(); i++) {
            ImportConfigBean importConfigBean = mVersions.get(i);
            if (null == importConfigBean) {
                MLog.i(TAG, "onClick() -> importConfigBean is null!");
                continue;
            }

            if (i == position) {
                importConfigBean.setState(Constant.CONFIG_VERSION_CHECKED);
            } else {
                importConfigBean.setState(Constant.CONFIG_VERSION_UNCHECKED);
            }
        }

        notifyDataSetChanged();
        mOnItemClickListener.onItemClick(position);
    }

    @NonNull
    @Override
    public ConfigRvHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.config_version_item, parent, false);
        ConfigRvHolder configRvHolder = new ConfigRvHolder(view);
        view.setOnClickListener(this);
        return configRvHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull ConfigRvHolder holder, int position) {
        if (null == mVersions) {
            MLog.e(TAG, "onBindViewHolder() -> mVersions is null!");
            return;
        }

        ImportConfigBean importConfigBean = mVersions.get(position);
        if (null == importConfigBean) {
            MLog.e(TAG, "onBindViewHolder() -> importConfigBean is null!");
            return;
        }

        holder.version.setText(importConfigBean.getVersion());
        switch (importConfigBean.getState()) {
            case Constant.CONFIG_VERSION_CHECKED:
                holder.tick.setVisibility(View.VISIBLE);
                break;
            case Constant.CONFIG_VERSION_UNCHECKED:
                holder.tick.setVisibility(View.INVISIBLE);
                break;
            default:
                break;
        }

        holder.itemView.setTag(position);
    }

    @Override
    public int getItemCount() {
        return null == mVersions ? 0 : mVersions.size();
    }

    class ConfigRvHolder extends RecyclerView.ViewHolder {

        TextView version;
        ImageButton tick;

        ConfigRvHolder(View itemView) {
            super(itemView);
            version = itemView.findViewById(R.id.tv_import_config_version);
            tick = itemView.findViewById(R.id.ib_import_config_tick);
        }
    }
}
