package com.chinapex.android.monitor.utils;

import android.graphics.Color;

import java.util.Random;

/**
 * @author wyhusky
 * @date 2019/1/10
 */
public class ColorUtils {

    private static int colorPointer = 0;
    private static Random random = new Random();

    /**
     * 饼图预留颜色
     */
    private static final int[] PRE_COLOR_ARRAY = {
            Color.rgb(192, 255, 140),
            Color.rgb(255, 247, 140),
            Color.rgb(255, 208, 140),
            Color.rgb(140, 234, 255),
            Color.rgb(255, 140, 157),
            Color.rgb(217, 80, 138),
            Color.rgb(254, 149, 7),
            Color.rgb(200, 247, 120),
            Color.rgb(106, 167, 134),
            Color.rgb(53, 194, 209),
            Color.rgb(193, 37, 82),
            Color.rgb(255, 102, 0),
            Color.rgb(245, 199, 0),
            Color.rgb(106, 150, 31),
            Color.rgb(179, 100, 53),
            Color.rgb(207, 248, 246),
            Color.rgb(148, 212, 212),
            Color.rgb(136, 180, 187),
            Color.rgb(118, 174, 175),
            Color.rgb(42, 109, 130),
            Color.rgb(64, 89, 128),
            Color.rgb(149, 165, 124),
            Color.rgb(217, 184, 162),
            Color.rgb(191, 134, 134),
            Color.rgb(179, 48, 80),
            Color.rgb(46, 204, 113),
            Color.rgb(241, 196, 15),
            Color.rgb(231, 76, 60),
            Color.rgb(52, 152, 219),
            Color.rgb(51, 181, 229)
    };

    public static int[] generateColorArray(int nums) {
        if (nums <= PRE_COLOR_ARRAY.length) {
            return PRE_COLOR_ARRAY;
        } else {
            int[] colorArray = new int[nums];
            int i = 0;
            for (; i < PRE_COLOR_ARRAY.length; i++) {
                colorArray[i] = PRE_COLOR_ARRAY[i];
            }
            for (; i < nums; i++) {
                int red = random.nextInt(255);
                int green = random.nextInt(255);
                int blue = random.nextInt(255);
                colorArray[i] = Color.rgb(red, green, blue);
            }
            return colorArray;
        }
    }

    public static int generateColor() {
        if (colorPointer < PRE_COLOR_ARRAY.length) {
            return PRE_COLOR_ARRAY[colorPointer++];
        }

        int red = random.nextInt(255);
        int green = random.nextInt(255);
        int blue = random.nextInt(255);
        return Color.rgb(red, green, blue);
    }

    public static void reset() {
        colorPointer = 0;
    }
}
