package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SpUtils;

import java.util.Iterator;
import java.util.Map;

/**
 * @author SteelCabbage
 * @date 2019/03/28
 */
public class WriteExpandablePvToSp implements Runnable {

    private static final String TAG = WriteExpandablePvToSp.class.getSimpleName();

    public WriteExpandablePvToSp() {
    }

    @Override
    public void run() {
        Map<String, Map<String, String>> expandablePvBeans = MonitorCache.getInstance().getExpandablePvBeans();
        if (null == expandablePvBeans) {
            MLog.e(TAG, "run() -> expandablePvBeans is null!");
            return;
        }

        Iterator<Map.Entry<String, Map<String, String>>> iterator = expandablePvBeans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, String>> expandablePvBean = iterator.next();
            if (null == expandablePvBean) {
                MLog.e(TAG, "run() -> expandablePvBean is null!");
                continue;
            }

            Map<String, String> expandableFindPath = expandablePvBean.getValue();
            if (null == expandableFindPath || expandableFindPath.isEmpty()) {
                iterator.remove();
            }
        }

        String expandablePvBeansJsonStr = GsonUtils.toJsonStr(expandablePvBeans);
        if (TextUtils.isEmpty(expandablePvBeansJsonStr)) {
            MLog.e(TAG, "run() -> expandablePvBeansJsonStr is null or empty!");
            return;
        }

        SpUtils.putParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_EXPANDABLE_PV, expandablePvBeansJsonStr);
    }
}
