package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.BitmapStorageUtil;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wyhusky
 * @date 2019-05-21
 */
public class UploadSnapshots implements Runnable, INetCallback {

    private static final String TAG = UploadSnapshots.class.getSimpleName();
    private List<UploadViewBean> mUploadViewBeans;
    private IUpdateUI iUpdateUI;

    public UploadSnapshots(List<UploadViewBean> uploadViewBeans, IUpdateUI iUpdateUI) {
        this.iUpdateUI = iUpdateUI;
        mUploadViewBeans = new ArrayList<>();
        mUploadViewBeans.clear();
        mUploadViewBeans.addAll(uploadViewBeans);
    }

    @Override
    public void run() {
        if (mUploadViewBeans.isEmpty()) {
            MLog.e(TAG, "uploadViewBeans is empty");
            return;
        }

        Map<String, String> map = new HashMap<>();
        for (UploadViewBean uploadViewBean : mUploadViewBeans) {
            String viewMD5 = uploadViewBean.getMd5();
            String fileName = viewMD5 + Constant.BITMAP_STORAGE_SUFFIX;
            String filePath = BitmapStorageUtil.getBitmapStoragePath(viewMD5);
            File file = new File(filePath);
            if (file.exists()) {
                map.put(fileName, filePath);
            }
        }

        OkHttpClientManager.getInstance().postMultipartSnapshotRequest(MonitorCache.getInstance().getServerRoot() + Constant.URL_UPLOAD_SNAPSHOT, map, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess()-> result:" + result);
        if (TextUtils.isEmpty(result)) {
            MLog.e(TAG, "onSuccess()-> reuslt is null or empty");
            return;
        }
        iUpdateUI.updateUI(true, result);
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed()-> failedCode:" + failedCode + " msg:" + msg);
        iUpdateUI.updateUI(false, msg);
    }
}
