package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.bean.request.GetAllConfigVersionsRequest;
import com.chinapex.android.monitor.bean.response.GetAllConfigVersionsResponse;
import com.chinapex.android.monitor.callback.IGetAllConfigVersionsCallback;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PhoneStateUtils;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

/**
 * @author SteelCabbage
 * @date 2019/05/10
 */
public class GetAllConfigVersions implements Runnable, INetCallback {

    private static final String TAG = GetAllConfigVersions.class.getSimpleName();

    private IGetAllConfigVersionsCallback mIGetAllConfigVersionsCallback;

    public GetAllConfigVersions(IGetAllConfigVersionsCallback iGetAllConfigVersionsCallback) {
        mIGetAllConfigVersionsCallback = iGetAllConfigVersionsCallback;
    }

    @Override
    public void run() {
        if (null == mIGetAllConfigVersionsCallback) {
            MLog.e(TAG, "run() -> mIGetAllConfigVersionsCallback is null!");
            return;
        }

        String appName = PhoneStateUtils.getAppName(MonitorCache.getInstance().getContext());
        if (TextUtils.isEmpty(appName)) {
            MLog.e(TAG, "run() -> appName is null or empty!");
            return;
        }

        GetAllConfigVersionsRequest getAllConfigVersionsRequest = new GetAllConfigVersionsRequest();
        getAllConfigVersionsRequest.setAppName(appName);
        getAllConfigVersionsRequest.setTerminal(Constant.TERMINAL);

        String getAllConfigVersionsRequestJson = GsonUtils.toJsonStr(getAllConfigVersionsRequest);
        MLog.i(TAG, "run() -> getAllConfigVersionsRequestJson:" + getAllConfigVersionsRequestJson);

        OkHttpClientManager.getInstance().postJson(MonitorCache.getInstance().getServerRoot() + Constant.URL_GET_ALL_CONFIG_VERSIONS,
                getAllConfigVersionsRequestJson, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess()-> result:" + result);
        if (TextUtils.isEmpty(result)) {
            MLog.e(TAG, "onSuccess()-> result is null or empty!");
            mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
            return;
        }

        GetAllConfigVersionsResponse response = GsonUtils.json2Bean(result, GetAllConfigVersionsResponse.class);
        if (null == response) {
            MLog.e(TAG, "onSuccess()-> response is null!");
            mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
            return;
        }

        int status = response.getStatus();
        if (Constant.RESPONSE_OK != status) {
            MLog.e(TAG, "onSuccess()-> status is not 200!");
            mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
            return;
        }

        mIGetAllConfigVersionsCallback.getAllConfigVersions(response.getData());
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed()-> failedCode:" + failedCode + " msg:" + msg);
        mIGetAllConfigVersionsCallback.getAllConfigVersions(null);
    }
}
