package com.chinapex.android.monitor.changelistener;

import com.chinapex.android.monitor.utils.MLog;

import java.util.ArrayList;
import java.util.List;

/**
 * @author SteelCabbage
 * @date 2018/12/03
 */
public class MonitorListenerController {

    private static final String TAG = MonitorListenerController.class.getSimpleName();

    private List<OnComparisonElementsChangeListener> mOnComparisonElementsChangeListeners;
    private List<IDownloadConfigCallback> mIDownloadConfigCallbacks;

    private MonitorListenerController() {

    }

    private static class MonitorListenerControllerHolder {
        private static final MonitorListenerController MONITOR_LISTENER_CONTROLLER = new MonitorListenerController();
    }

    public static MonitorListenerController getInstance() {
        return MonitorListenerControllerHolder.MONITOR_LISTENER_CONTROLLER;
    }

    public void doInit() {
        mOnComparisonElementsChangeListeners = new ArrayList<>();
        mIDownloadConfigCallbacks = new ArrayList<>();
    }

    public void onDestroy() {
        if (null == mOnComparisonElementsChangeListeners) {
            MLog.e(TAG, "onDestroy() -> mOnComparisonElementsChangeListeners is null!");
            return;
        }

        if (null == mIDownloadConfigCallbacks) {
            MLog.e(TAG, "onDestroy() -> mIDownloadConfigCallbacks is null!");
            return;
        }

        mOnComparisonElementsChangeListeners.clear();
        mIDownloadConfigCallbacks.clear();

        mOnComparisonElementsChangeListeners = null;
        mIDownloadConfigCallbacks = null;
    }

    public void addOnComparisonElementsChangeListener(OnComparisonElementsChangeListener onComparisonElementsChangeListener) {
        if (null == mOnComparisonElementsChangeListeners || null == onComparisonElementsChangeListener) {
            MLog.e(TAG, "1: mOnComparisonElementsChangeListeners or onComparisonElementsChangeListener is null!");
            return;
        }

        mOnComparisonElementsChangeListeners.add(onComparisonElementsChangeListener);
    }

    public void addIDownloadConfigCallback(IDownloadConfigCallback iDownloadConfigCallback) {
        if (null == mIDownloadConfigCallbacks || null == iDownloadConfigCallback) {
            MLog.e(TAG, "1: mIDownloadConfigCallbacks or iDownloadConfigCallback is null!");
            return;
        }

        mIDownloadConfigCallbacks.add(iDownloadConfigCallback);
    }


    public void removeOnComparisonElementsChangeListener(OnComparisonElementsChangeListener onComparisonElementsChangeListener) {
        if (null == mOnComparisonElementsChangeListeners || null == onComparisonElementsChangeListener) {
            MLog.e(TAG, "0: mOnComparisonElementsChangeListeners or onComparisonElementsChangeListener is null!");
            return;
        }

        mOnComparisonElementsChangeListeners.remove(onComparisonElementsChangeListener);
    }

    public void removeIDownloadConfigCallback(IDownloadConfigCallback iDownloadConfigCallback) {
        if (null == mIDownloadConfigCallbacks || null == iDownloadConfigCallback) {
            MLog.e(TAG, "0: mIDownloadConfigCallbacks or iDownloadConfigCallback is null!");
            return;
        }

        mIDownloadConfigCallbacks.remove(iDownloadConfigCallback);
    }


    public void notifyComparisonElementsChange() {
        if (null == mOnComparisonElementsChangeListeners) {
            MLog.e(TAG, "notifyComparisonElementsChange() -> mOnComparisonElementsChangeListeners is null!");
            return;
        }

        for (OnComparisonElementsChangeListener onComparisonElementsChangeListener : mOnComparisonElementsChangeListeners) {
            if (null == onComparisonElementsChangeListener) {
                MLog.e(TAG, "notifyComparisonElementsChange() -> onComparisonElementsChangeListener is null!");
                continue;
            }

            onComparisonElementsChangeListener.comparisonElementsChange();
        }
    }

    public void notifyDownloadConfig(boolean isSuccessful) {
        if (null == mIDownloadConfigCallbacks) {
            MLog.e(TAG, "notifyDownloadConfig() -> mIDownloadConfigCallbacks is null!");
            return;
        }

        for (IDownloadConfigCallback iDownloadConfigCallback : mIDownloadConfigCallbacks) {
            if (null == iDownloadConfigCallback) {
                MLog.e(TAG, "notifyDownloadConfig() -> iDownloadConfigCallback is null!");
                continue;
            }

            iDownloadConfigCallback.downloadConfig(isSuccessful);
        }
    }

}
