/*
 * Decompiled with CFR 0.152.
 */
package com.chinapex.android.monitor.view.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.utils.MLog;
import java.util.ArrayList;
import java.util.List;

public class PageAdapter
extends BaseAdapter {
    private static final String TAG = PageAdapter.class.getSimpleName();
    private static final String HASH_SEPARATOR = "##";
    private static final String DOT_SEPARATOR = "\\.";
    private List<String> pages;
    private List<String> simpleName;
    private Context mContext;

    public PageAdapter(Context context) {
        this.mContext = context;
        this.pages = new ArrayList<String>();
        this.simpleName = new ArrayList<String>();
    }

    public void addAll(List<String> list) {
        this.pages.addAll(list);
        for (String string2 : list) {
            this.simpleName.add(this.getSimpleName(string2));
        }
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.pages.clear();
        this.simpleName.clear();
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.pages.size();
    }

    public Object getItem(int n2) {
        return this.pages.get(n2);
    }

    public long getItemId(int n2) {
        return n2;
    }

    public View getView(int n2, View view, ViewGroup viewGroup) {
        View view2;
        if (null == view) {
            view2 = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_spinner_item, viewGroup, false);
            TextView textView = (TextView)view2.findViewById(R.id.spinner_text);
            textView.setText((CharSequence)this.simpleName.get(n2));
            view2.setTag((Object)textView);
        } else {
            view2 = view;
            TextView textView = (TextView)view2.getTag();
            textView.setText((CharSequence)this.simpleName.get(n2));
        }
        return view2;
    }

    private String getSimpleName(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            MLog.e(TAG, "getSimpleName()-> str is null");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string2.split(HASH_SEPARATOR);
        if (stringArray.length == 0) {
            MLog.e(TAG, "getSimpleName()-> fragmentNames is empty");
            return "";
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split(DOT_SEPARATOR);
            if (stringArray2.length == 0) {
                MLog.e(TAG, "getSimpleName()-> partNames is empty");
                return "";
            }
            String string3 = stringArray2[stringArray2.length - 1];
            if (i2 > 0) {
                stringBuilder.append(HASH_SEPARATOR);
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }
}

