package com.chinapex.android.monitor.view.upload;

import com.chinapex.android.monitor.bean.UploadViewBean;
import com.chinapex.android.monitor.callback.IWriteConfigToSpCallback;
import com.chinapex.android.monitor.view.BasePresenter;
import com.chinapex.android.monitor.view.BaseView;

import java.util.List;

/**
 * @author wyhusky
 * @date 2019/1/17
 */
public interface UploadViewContract {
    interface View extends BaseView {
        /**
         * 显示上传成功
         */
        void showUploadSuccess();

        /**
         * 显示上传失败
         */
        void showUploadFailed();

        /**
         * 显示上传中
         */
        void showUploading();
    }

    interface Presenter extends BasePresenter {

        /**
         * 上传配置文件及截图
         *
         * @param uploadViewBeans 上传的视图的bean文件，需要根据视图bean的md5值批量传图
         */
        void upload(List<UploadViewBean> uploadViewBeans);
    }
}
