package com.chinapex.android.monitor.view.snapshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.WindowManager;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.utils.DensityUtil;
import com.chinapex.android.monitor.view.BaseFloatingView;

/**
 * @author wyhusky
 * @date 2019-04-23
 */
public class SnapshotView extends BaseFloatingView {

    private ImageView ivSnapshot;

    public SnapshotView(@NonNull Context context, int windowType) {
        super(context, windowType);
        inflate(context, R.layout.layout_window_snapshot, this);
        setBackgroundColor(Color.BLACK);
        resetLayoutParams();
        ivSnapshot = findViewById(R.id.iv_snapshot);
        int screenWidth = DensityUtil.getScreenWidth(context);
        int screenHeight = DensityUtil.getScreenHeight(context);
        ivSnapshot.setMaxWidth(screenWidth * 2 / 3);
        ivSnapshot.setMaxHeight(screenHeight * 2 / 3);
    }

    public void loadImage(Bitmap bitmap) {
        Glide.with(this).clear(ivSnapshot);
        Glide.with(this).load(bitmap).centerInside().into(ivSnapshot);
    }

    public void loadImage(String path) {
        Glide.with(this).clear(ivSnapshot);
        Glide.with(this).load(path).centerInside().into(ivSnapshot);
    }

    private WindowManager.LayoutParams resetLayoutParams() {
        WindowManager.LayoutParams params = getWindowParams();
        params.width = LayoutParams.MATCH_PARENT;
        params.height = LayoutParams.MATCH_PARENT;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            params.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
        } else {
            params.type = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
        }
        params.flags = WindowManager.LayoutParams.FLAG_FULLSCREEN;
        params.format = PixelFormat.TRANSLUCENT;
        params.gravity = Gravity.CENTER;

        return params;
    }
}
