package com.chinapex.android.monitor.view.loading;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.FloatingViewManager;
import com.chinapex.android.monitor.view.IFloatingView;

/**
 * @author SteelCabbage
 * @date 2019/05/13
 */
public class LoadingView extends BaseFloatingView implements View.OnClickListener {

    private static final String TAG = LoadingView.class.getSimpleName();
    private ProgressBar mPbLoading;
    private ImageView mIvLoadingPicture;
    private TextView mTvLoadingContent;
    private Button mBtLoadingContent;

    public LoadingView(@NonNull Context context, int windowType) {
        super(context, windowType);
        inflate(context, R.layout.layout_window_loading, this);

        initView();
    }

    private void initView() {
        mPbLoading = findViewById(R.id.pb_loading);
        mIvLoadingPicture = findViewById(R.id.iv_loading_picture);
        mTvLoadingContent = findViewById(R.id.tv_loading_content);
        mBtLoadingContent = findViewById(R.id.bt_loading_content);
        mBtLoadingContent.setOnClickListener(this);
    }

    public void setLoading(String content) {
        mPbLoading.setVisibility(VISIBLE);
        mIvLoadingPicture.setVisibility(INVISIBLE);
        mTvLoadingContent.setText(content);
        mBtLoadingContent.setText("取消");
        mBtLoadingContent.setBackgroundResource(R.drawable.bg_loading);
    }

    public void setLoadingOk(String content) {
        mPbLoading.setVisibility(GONE);
        mIvLoadingPicture.setVisibility(VISIBLE);
        mIvLoadingPicture.setImageResource(R.drawable.upload_ok_48);
        mTvLoadingContent.setText(content);
        mBtLoadingContent.setText("确认");
        mBtLoadingContent.setBackgroundResource(R.drawable.bg_loading_ok);
    }

    public void setLoadingFail(String content) {
        mPbLoading.setVisibility(GONE);
        mIvLoadingPicture.setVisibility(VISIBLE);
        mIvLoadingPicture.setImageResource(R.drawable.upload_fail_48);
        mTvLoadingContent.setText(content);
        mBtLoadingContent.setText("取消");
        mBtLoadingContent.setBackgroundResource(R.drawable.bg_loading_fail);
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (R.id.bt_loading_content == viewId) {
            FloatingViewManager.getInstance().dismissFloatingView(IFloatingView.WINDOW_LOADING);
        }
    }
}
