package com.chinapex.android.monitor.view.event;

import android.content.Context;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.chinapex.android.monitor.R;
import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.view.BaseFloatingView;
import com.chinapex.android.monitor.view.IFloatingView;
import com.chinapex.android.monitor.view.adapter.PageAdapter;
import com.chinapex.android.monitor.view.charts.LineChartContainer;

import java.util.List;
import java.util.Map;


/**
 * @author wyhusky
 * @date 2018/12/27
 */
public class DefineEventView extends BaseFloatingView implements DefineEventContract.View, View.OnClickListener {

    private static final String TAG = DefineEventView.class.getSimpleName();
    private DefineEventContract.Presenter mPresenter;
    private LineChartContainer mLineChartContainer;
    private EditText mEditEventName;
    private TextView mTvViewPath, mTvDataPath;
    private Spinner mSpinnerPagePath;
    private PageAdapter mPageAdapter;
    private TextView mTvPathLabel;
    private Button mBtnSnapshot;


    public DefineEventView(Context context, int windowType) {
        super(context, windowType);
        inflate(context, R.layout.layout_window_define_page, this);
        mPageAdapter = new PageAdapter(context);
        setPresenter(new DefineEventPresenter(this));
        initView();
    }

    public void loadClickData(View view, String viewPath, String pageClass, String findPath) {
        mPresenter.loadClickData(view, viewPath, pageClass, findPath);
    }

    public void loadListItemClickData(View view, String viewPath, String pageClass, String itemPath, String findPath, int listType) {
        mPresenter.loadListItemClickData(view, viewPath, pageClass, itemPath, findPath, listType);
    }

    @Override
    public void showAlias(String alias) {
        if (TextUtils.isEmpty(alias)) {
            mEditEventName.setText(null);
            MLog.w(TAG, "showAlias() -> alias is null or empty!");
            return;
        }

        mEditEventName.setText(alias);
    }

    @Override
    public void showViewPath(String path) {
        if (null == mTvViewPath) {
            MLog.e(TAG, "showViewPath()-> mTvViewPath is null");
            return;
        }
        mTvViewPath.setText(path);
    }

    @Override
    public void loadPagePath(List<String> pages) {
        mPageAdapter.clear();
        mPageAdapter.addAll(pages);

        if (mPageAdapter.isEmpty()) {
            MLog.e(TAG, "loadPagePath() -> mPageAdapter is empty!");
            return;
        }

        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        if (null == pvBeans) {
            MLog.e(TAG, "loadPagePath() -> pvBeans is null!");
            return;
        }

        String viewPath = (String) mPageAdapter.getItem(0);
        ConfigBean.PvBean pvBean = pvBeans.get(MD5Utils.getMD5(viewPath));
        if (null != pvBean) {
            showAlias(pvBean.getAlias());
        } else {
            mEditEventName.setText(null);
        }
    }

    @Override
    public void showReference(String reference) {
        if (null == mTvDataPath) {
            MLog.e(TAG, "showViewPath()-> mTvViewPath is null");
            return;
        }
        mTvDataPath.setText(reference);
    }

    @Override
    public void showLineChart(long[] dateArray, long[] clickCountArray, long[] pvCountArray) {
        if (null == mLineChartContainer) {
            MLog.e(TAG, "showLineChart()-> mLineChart is null");
            return;
        }
        mLineChartContainer.setData(dateArray, clickCountArray, pvCountArray);
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.btn_save_define_event) {
            save();
        } else if (viewId == R.id.btn_cancel_define_event) {
            mPresenter.dismiss();
        } else if (viewId == R.id.btn_snapshot) {
            mPresenter.showSnapShot();
        }
    }

    @Override
    public void setPresenter(Object presenter) {
        this.mPresenter = (DefineEventContract.Presenter) presenter;
    }

    @Override
    public int getViewType() {
        return getWindowType();
    }

    @Override
    public void showToast(int id) {
        Toast.makeText(this.getContext(), getResources().getText(id).toString(), Toast.LENGTH_LONG).show();
    }

    private void initView() {
        mLineChartContainer = findViewById(R.id.line_chart_container);
        mBtnSnapshot = findViewById(R.id.btn_snapshot);
        mBtnSnapshot.setOnClickListener(this);
        findViewById(R.id.btn_save_define_event).setOnClickListener(this);
        findViewById(R.id.btn_cancel_define_event).setOnClickListener(this);

        mEditEventName = findViewById(R.id.et_event_name);

        // viewPath可能过长, 最大5行且设置为可滚动
        mTvViewPath = findViewById(R.id.tv_view_path);
        mTvViewPath.setMovementMethod(ScrollingMovementMethod.getInstance());

        mSpinnerPagePath = findViewById(R.id.spinner_page_path);
        mTvDataPath = findViewById(R.id.tv_data_path);
        mTvPathLabel = findViewById(R.id.tv_path_label);
        mSpinnerPagePath.setAdapter(mPageAdapter);
        mSpinnerPagePath.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
                if (null == pvBeans) {
                    MLog.e(TAG, "Spinner onItemSelected() -> pvBeans is null!");
                    return;
                }

                String viewPath = (String) mPageAdapter.getItem(position);
                ConfigBean.PvBean pvBean = pvBeans.get(MD5Utils.getMD5(viewPath));
                if (null != pvBean) {
                    showAlias(pvBean.getAlias());
                } else {
                    mEditEventName.setText(null);
                }
                mPresenter.updatePvData(viewPath);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        final String elementPath = getResources().getString(R.string.defined_page);
        switch (getWindowType()) {
            case IFloatingView.WINDOW_DEFINE_CLICK_PAGE:
                mTvPathLabel.setText(elementPath);
                mSpinnerPagePath.setVisibility(GONE);
                mTvViewPath.setVisibility(VISIBLE);
                break;
            case IFloatingView.WINDOW_DEFINE_PV_PAGE:
                String reference = getResources().getString(R.string.reference);
                mTvPathLabel.setText(reference);
                mTvViewPath.setVisibility(GONE);
                mSpinnerPagePath.setVisibility(VISIBLE);
                loadPvData();
                break;
            case IFloatingView.WINDOW_DEFINE_LIST_PAGE:
                mTvPathLabel.setText(elementPath);
                mSpinnerPagePath.setVisibility(GONE);
                mTvViewPath.setVisibility(VISIBLE);
                break;
            default:
                MLog.e(TAG, "initView()-> no this view type, show pv define page");
                String label = getResources().getString(R.string.reference);
                mTvPathLabel.setText(label);
                mTvViewPath.setVisibility(GONE);
                mSpinnerPagePath.setVisibility(VISIBLE);
                loadPvData();
                break;
        }
    }

    private void save() {
        String alias = mEditEventName.getText().toString();
        if (TextUtils.isEmpty(alias)) {
            MLog.e(TAG, "alias is empty");
            Toast.makeText(this.getContext(), getResources().getText(R.string.alias_leak_hint).toString(), Toast.LENGTH_LONG).show();
            return;
        }
        switch (getViewType()) {
            case IFloatingView.WINDOW_DEFINE_CLICK_PAGE:
                mPresenter.saveClickEvent(alias);
                break;
            case IFloatingView.WINDOW_DEFINE_LIST_PAGE:
                String itemPath = mTvViewPath.getText().toString();
                if (TextUtils.isEmpty(itemPath)) {
                    MLog.e(TAG, "itemPath is empty");
                    Toast.makeText(this.getContext(), getResources().getText(R.string.alias_leak_hint).toString(),
                            Toast.LENGTH_LONG).show();
                    return;
                }
                mPresenter.saveListItemClickEvent(alias, itemPath);
                break;
            case IFloatingView.WINDOW_DEFINE_PV_PAGE:
                String definedPage = mSpinnerPagePath.getSelectedItem().toString();
                if (TextUtils.isEmpty(definedPage)) {
                    MLog.e(TAG, "defined page is empty");
                    Toast.makeText(this.getContext(), getResources().getText(R.string.defined_page_hint).toString(),
                            Toast.LENGTH_LONG).show();
                    return;
                }
                mPresenter.savePageViewEvent(alias, definedPage);
                break;
            default:
                MLog.e(TAG, "save event:no this view type");
                break;
        }
    }

    private void loadPvData() {
        mPresenter.loadPvData();
    }
}
