package com.chinapex.android.monitor.view;

import android.content.Context;
import android.graphics.PixelFormat;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.widget.FrameLayout;

import com.chinapex.android.monitor.utils.MLog;

/**
 * @author wyhusky
 * @date 2019-04-23
 */
public class BaseFloatingView extends FrameLayout implements IFloatingView {

    private static final String TAG = BaseFloatingView.class.getSimpleName();

    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mParams;
    private int mWindowType;

    public BaseFloatingView(@NonNull Context context, int windowType) {
        super(context);
        mWindowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        mParams = getDefaultParams();
        mWindowType = windowType;
    }

    @Override
    public void show() {
        setVisibility(VISIBLE);
        try {
            mWindowManager.addView(this, mParams);
        } catch (Exception e) {
            MLog.e(TAG, "show exception:" + e.getMessage());
        }
    }

    @Override
    public void hide() {
        setVisibility(INVISIBLE);
    }

    @Override
    public void dismiss() {
        try {
            mWindowManager.removeView(this);
        } catch (Exception e) {
            MLog.e(TAG, "show exception:" + e.getMessage());
        }
    }

    @Override
    public boolean isHiding() {
        return getVisibility() == INVISIBLE;
    }

    public int getWindowType() {
        return mWindowType;
    }

    protected WindowManager.LayoutParams getWindowParams() {
        return mParams;
    }

    protected void updateLayout() {
        mWindowManager.updateViewLayout(this, mParams);
    }

    private WindowManager.LayoutParams getDefaultParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.width = LayoutParams.MATCH_PARENT;
        params.height = LayoutParams.MATCH_PARENT;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            params.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
        } else {
            params.type = WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY;
        }
        params.flags = WindowManager.LayoutParams.FLAG_FULLSCREEN;
        params.format = PixelFormat.TRANSLUCENT;
        params.gravity = Gravity.CENTER;
        return params;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_UP) {
            FloatingViewManager.getInstance().dismissFloatingView(mWindowType);
            return true;
        }
        return super.dispatchKeyEvent(event);
    }
}
