package com.chinapex.android.monitor.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;

/**
 * @author wyhusky
 * @date 2019-04-19
 */
public class SnapshotUtil {
    private static final String TAG = SnapshotUtil.class.getSimpleName();

    public static Bitmap takeSnapshot(View view) {
        if (null == view) {
            MLog.e(TAG, "takeSnapshot()-> view is null!");
            return null;
        }

        int width = view.getWidth();
        int height = view.getHeight();

        if (width == 0 || height == 0) {
            MLog.e(TAG, "takeSnapshot()-> full layout of this view is not finished!");
            return null;
        }

        Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }
}
