package com.chinapex.android.monitor.utils;

import java.text.NumberFormat;

/**
 * @author SteelCabbage
 * @date 2019/04/18
 */
public class NumberUtils {

    private static final String TAG = NumberUtils.class.getSimpleName();

    public static String getFormatPercent(double d, int digits) {
        NumberFormat percentInstance = NumberFormat.getPercentInstance();
        percentInstance.setMinimumFractionDigits(digits);
        String percent = "";
        try {
            percent = percentInstance.format(d / 100);
        } catch (Exception e) {
            MLog.e(TAG, "getFormatPercent() -> NumberFormat Exception:" + e.getMessage());
        }

        return percent;
    }

    public static String getThousandSeparatorNum(long number) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        String formatNum = "";
        try {
            formatNum = numberInstance.format(number);
        } catch (Exception e) {
            MLog.e(TAG, "getThousandSeparatorNum() -> NumberFormat Exception:" + e.getMessage());
        }

        return formatNum;
    }

}
