package com.chinapex.android.monitor.utils;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;

import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @author wyhusky
 * @date 2019-04-23
 */
public class BitmapStorageUtil {
    private static final String TAG = BitmapStorageUtil.class.getSimpleName();

    public static void saveBitmap(String viewMD5, Bitmap bitmap) {
        if (TextUtils.isEmpty(viewMD5)) {
            MLog.e(TAG, "saveBitmap()-> viewMD5 is empty");
            return;
        }

        if (null == bitmap) {
            MLog.e(TAG, "saveBitmap()-> bitmap is null");
            return;
        }

        FileOutputStream fos = null;
        String fileName = viewMD5 + Constant.BITMAP_STORAGE_SUFFIX;
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED) && checkWritePermission()) {
            String snapshotFileDirPath = Environment.getExternalStorageDirectory().getPath() + Constant.SNAPSHOT_FILE_DIR;
            File snapshotDir = new File(snapshotFileDirPath);
            if (!snapshotDir.exists()) {
                boolean isSuccess = snapshotDir.mkdirs();
                if (!isSuccess) {
                    MLog.e(TAG, "saveBitmap()-> mkdir failed!");
                }
            }
            File snapshotFile = new File(snapshotFileDirPath + fileName);
            try {
                fos = new FileOutputStream(snapshotFile);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, fos);
            } catch (Exception e) {
                MLog.e(TAG, e.getMessage());
            } finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                } catch (IOException e) {
                    MLog.e(TAG, e.getMessage());
                }
            }
        } else {
            Context context = MonitorCache.getInstance().getContext();
            if (null == context) {
                MLog.e(TAG, "saveBitmap()-> context is null!");
                return;
            }
            try {
                fos = context.openFileOutput(fileName, Context.MODE_PRIVATE);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, fos);
            } catch (FileNotFoundException e) {
                MLog.e(TAG, e.getMessage());
            } finally {
                if (null != fos) {
                    try {
                        fos.close();
                    } catch (IOException e) {
                        MLog.e(TAG, e.getMessage());
                    }
                }
            }
        }
    }

    public static String getBitmapStoragePath(String viewMD5) {
        StringBuilder sb = new StringBuilder();
        String dirPath;
        String fileName = viewMD5 + Constant.BITMAP_STORAGE_SUFFIX;

        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED) && checkWritePermission()) {
            dirPath = Environment.getExternalStorageDirectory().getPath() + Constant.SNAPSHOT_FILE_DIR;
        } else {
            Context context = MonitorCache.getInstance().getContext();
            if (null == context) {
                MLog.e(TAG, "saveBitmap()-> context is null!");
                return sb.toString();
            }
            dirPath = context.getFilesDir().getAbsolutePath() + File.separator;
        }
        sb.append(dirPath).append(fileName);
        return sb.toString();
    }

    public static boolean isBitmapExist(String md5) {
        File file = new File(getBitmapStoragePath(md5));
        return file.exists();
    }

    public static boolean checkWritePermission() {
        Context context = MonitorCache.getInstance().getContext();
        if (null == context) {
            MLog.e(TAG, "checkWritePermission()-> can not get context!");
            return false;
        }

        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            PackageManager pm = context.getPackageManager();
            if (null == pm) {
                MLog.e(TAG, "checkWritePermission()-> can not get packageManager!");
                return false;
            }
            return pm.checkPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE, context.getPackageName()) ==
                    PackageManager.PERMISSION_GRANTED;
        } else {
            return context.checkSelfPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE) ==
                    PackageManager.PERMISSION_GRANTED;
        }
    }
}
