package com.chinapex.android.monitor.global;

import android.content.Context;
import android.text.TextUtils;

import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.ContrastItem;
import com.chinapex.android.monitor.bean.StatisticsBean;
import com.chinapex.android.monitor.callback.IMonitorCallback;
import com.chinapex.android.monitor.changelistener.MonitorListenerController;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MD5Utils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SpUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;


/**
 * @author SteelCabbage
 * @date 2018/11/23
 */
public class MonitorCache {

    private static final String TAG = MonitorCache.class.getSimpleName();

    private Map<String, ConfigBean.ClickBean> mClickBeans = new HashMap<>();
    private Map<String, ConfigBean.PvBean> mPvBeans = new HashMap<>();
    private Map<String, ConfigBean.ListBean> mListBeans = new HashMap<>();
    private Map<String, Map<String, String>> mElemPvBeans = new HashMap<>();
    private Map<String, Map<String, String>> mRecyclerPvBeans = new HashMap<>();
    private Map<String, Map<String, String>> mListPvBeans = new HashMap<>();
    private Map<String, Map<String, String>> mExpandablePvBeans = new HashMap<>();

    private Set<ContrastItem> mContrastItemList = new HashSet<>();

    private MonitorCache() {

    }

    private static class MonitorCacheHolder {

        private static final MonitorCache MONITOR_CACHE = new MonitorCache();
    }

    public static MonitorCache getInstance() {
        return MonitorCacheHolder.MONITOR_CACHE;
    }

    /**
     * app的context
     */
    private Context mContext;

    /**
     * 圈选模式开关的回调
     */
    private IMonitorCallback mIMonitorCallback;

    /**
     * 保存activity，fragment的栈
     */
    private Map<Integer, Stack<Map<String, Boolean>>> mTasks;

    /**
     * 指向栈顶activity的指针
     */
    private Map<Integer, Integer> mTop;

    /**
     * 指向前台任务栈
     */
    private int[] mForegroundTask;

    public Map<Integer, Stack<Map<String, Boolean>>> getTasks() {
        return mTasks;
    }

    public void setTasks(Map<Integer, Stack<Map<String, Boolean>>> mTasks) {
        this.mTasks = mTasks;
    }

    public Map<Integer, Integer> getTop() {
        return mTop;
    }

    public void setTop(Map<Integer, Integer> mTop) {
        this.mTop = mTop;
    }

    public int[] getForegroundTask() {
        return mForegroundTask;
    }

    public void setForegroundTask(int[] mForegroundTask) {
        this.mForegroundTask = mForegroundTask;
    }

    /**
     * SDK自身功能的服务器地址(配置文件上传, 折线图, 饼图)
     */
    private String mServerRoot = Constant.SERVER_ROOT;

    /**
     * Hostname verifier
     */
    private String hostnameVerifier = Constant.HOSTNAME_VERIFIER;

    public List<StatisticsBean> getStatisticsBeans() {
        return mStatisticsBeans;
    }

    public void setStatisticsBeans(List<StatisticsBean> statisticsBeans) {
        mStatisticsBeans = statisticsBeans;
    }

    public List<StatisticsBean> mStatisticsBeans = new ArrayList<>();

    public Context getContext() {
        return mContext;
    }

    public void setContext(Context context) {
        mContext = context;
    }

    public IMonitorCallback getIMonitorCallback() {
        return mIMonitorCallback;
    }

    public void setIMonitorCallback(IMonitorCallback iMonitorCallback) {
        mIMonitorCallback = iMonitorCallback;
    }

    public String getServerRoot() {
        return mServerRoot;
    }

    public void setServerRoot(String serverRoot) {
        mServerRoot = serverRoot;
    }

    public String getHostnameVerifier() {
        return hostnameVerifier;
    }

    public void setHostnameVerifier(String hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public Map<String, ConfigBean.ClickBean> getClickBeans() {
        return mClickBeans;
    }

    public void setClickBeans(Map<String, ConfigBean.ClickBean> clickBeans) {
        mClickBeans = clickBeans;
    }

    public void putClickBeans(String clickMD5, ConfigBean.ClickBean clickBean) {
        mClickBeans.put(clickMD5, clickBean);
    }

    public Map<String, ConfigBean.PvBean> getPvBeans() {
        return mPvBeans;
    }

    public void setPvBeans(Map<String, ConfigBean.PvBean> pvBeans) {
        mPvBeans = pvBeans;
    }

    public void putPvBeans(String pvMD5, ConfigBean.PvBean pvBean) {
        mPvBeans.put(pvMD5, pvBean);
    }

    public Map<String, ConfigBean.ListBean> getListBeans() {
        return mListBeans;
    }

    public void setListBeans(Map<String, ConfigBean.ListBean> listBeans) {
        mListBeans = listBeans;
    }

    public void putListBeans(String listMD5, ConfigBean.ListBean listBean) {
        mListBeans.put(listMD5, listBean);
    }

    public Map<String, Map<String, String>> getElemPvBeans() {
        return mElemPvBeans;
    }

    public void setElemPvBeans(Map<String, Map<String, String>> elemPvBeans) {
        mElemPvBeans = elemPvBeans;
    }

    public void putElemPvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty(pageClassNameMD5) || TextUtils.isEmpty(viewPathMD5) || TextUtils.isEmpty(findPath)) {
            MLog.e(TAG, "putElemPvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }

        Map<String, String> elemPvBean = mElemPvBeans.get(pageClassNameMD5);
        if (null == elemPvBean) {
            MLog.w(TAG, "putElemPvBeans() -> elemPvBean is null!");
            elemPvBean = new HashMap<>();
            elemPvBean.put(viewPathMD5, findPath);
            mElemPvBeans.put(pageClassNameMD5, elemPvBean);
            return;
        }

        elemPvBean.put(viewPathMD5, findPath);
    }

    public Map<String, Map<String, String>> getRecyclerPvBeans() {
        return mRecyclerPvBeans;
    }

    public void setRecyclerPvBeans(Map<String, Map<String, String>> recyclerPvBeans) {
        mRecyclerPvBeans = recyclerPvBeans;
    }

    public void putRecyclerPvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty(pageClassNameMD5) || TextUtils.isEmpty(viewPathMD5) || TextUtils.isEmpty(findPath)) {
            MLog.e(TAG, "putRecyclerPvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }

        Map<String, String> recyclerPvBean = mRecyclerPvBeans.get(pageClassNameMD5);
        if (null == recyclerPvBean) {
            MLog.w(TAG, "putRecyclerPvBeans() -> recyclerPvBean is null!");
            recyclerPvBean = new HashMap<>();
            recyclerPvBean.put(viewPathMD5, findPath);
            mRecyclerPvBeans.put(pageClassNameMD5, recyclerPvBean);
            return;
        }

        recyclerPvBean.put(viewPathMD5, findPath);
    }

    public Map<String, Map<String, String>> getListPvBeans() {
        return mListPvBeans;
    }

    private void setListPvBeans(Map<String, Map<String, String>> listPvBeans) {
        mListPvBeans = listPvBeans;
    }

    public void putListPvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty(pageClassNameMD5) || TextUtils.isEmpty(viewPathMD5) || TextUtils.isEmpty(findPath)) {
            MLog.e(TAG, "putListPvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }

        Map<String, String> listPvBean = mListPvBeans.get(pageClassNameMD5);
        if (null == listPvBean) {
            MLog.w(TAG, "putListPvBeans() -> listPvBean is null!");
            listPvBean = new HashMap<>();
            listPvBean.put(viewPathMD5, findPath);
            mListPvBeans.put(pageClassNameMD5, listPvBean);
            return;
        }

        listPvBean.put(viewPathMD5, findPath);
    }

    public Map<String, Map<String, String>> getExpandablePvBeans() {
        return mExpandablePvBeans;
    }

    public void setExpandablePvBeans(Map<String, Map<String, String>> expandablePvBeans) {
        mExpandablePvBeans = expandablePvBeans;
    }

    public void putExpandablePvBeans(String pageClassNameMD5, String viewPathMD5, String findPath) {
        if (TextUtils.isEmpty(pageClassNameMD5) || TextUtils.isEmpty(viewPathMD5) || TextUtils.isEmpty(findPath)) {
            MLog.e(TAG, "putExpandablePvBeans() -> pageClassNameMd5 or viewPathMd5 or findPath is null or empty!");
            return;
        }

        Map<String, String> expandablePvBean = mExpandablePvBeans.get(pageClassNameMD5);
        if (null == expandablePvBean) {
            MLog.w(TAG, "putExpandablePvBeans() -> expandablePvBean is null!");
            expandablePvBean = new HashMap<>();
            expandablePvBean.put(viewPathMD5, findPath);
            mExpandablePvBeans.put(pageClassNameMD5, expandablePvBean);
            return;
        }

        expandablePvBean.put(viewPathMD5, findPath);
    }

    public void getExistData() {
        getExistClick();
        getExistPv();
        getExistList();
        getExistElemPv();
        getExistRecyclerPv();
        getExistListPv();
        getExistExpandablePv();
    }

    private void getExistClick() {
        String clickBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_CLICK,
                Constant.SP_VALUE_DEFAULT_EVENT);
        if (TextUtils.isEmpty(clickBeanStr)) {
            MLog.i(TAG, "getExistClick -> clickBeanStr is null or empty!");
            return;
        }

        Map<String, ConfigBean.ClickBean> clickBeans = GsonUtils.json2ClickMap(clickBeanStr);
        if (null == clickBeans || clickBeans.isEmpty()) {
            MLog.i(TAG, "getExistClick -> clickBeans is null or empty!");
            return;
        }

        mClickBeans.putAll(clickBeans);
    }

    private void getExistPv() {
        String pvBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_PV,
                Constant.SP_VALUE_DEFAULT_EVENT);
        MLog.i(TAG, "getExistPv -> pvBeanStr :" + pvBeanStr);
        if (TextUtils.isEmpty(pvBeanStr)) {
            MLog.i(TAG, "getExistPv -> pvBeanStr is null or empty!");
            return;
        }

        Map<String, ConfigBean.PvBean> pvBeans = GsonUtils.json2PvMap(pvBeanStr);
        if (null == pvBeans || pvBeans.isEmpty()) {
            MLog.i(TAG, "getExistPv -> pvBeans is null or empty!");
            return;
        }

        mPvBeans.putAll(pvBeans);
    }

    private void getExistList() {
        String listBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_LIST,
                Constant.SP_VALUE_DEFAULT_EVENT);
        if (TextUtils.isEmpty(listBeanStr)) {
            MLog.i(TAG, "getExistList -> listBeanStr is null or empty!");
            return;
        }

        Map<String, ConfigBean.ListBean> listBeans = GsonUtils.json2ListMap(listBeanStr);
        if (null == listBeans || listBeans.isEmpty()) {
            MLog.i(TAG, "getExistList -> listBeans is null or empty!");
            return;
        }
        mListBeans.putAll(listBeans);
    }

    private void getExistElemPv() {
        String elemPvBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_ELEM_PV,
                Constant.SP_VALUE_DEFAULT_EVENT);
        MLog.i(TAG, "getExistElemPv -> elemPvBeanStr :" + elemPvBeanStr);
        if (TextUtils.isEmpty(elemPvBeanStr)) {
            MLog.i(TAG, "getExistElemPv -> elemPvBeanStr is null or empty!");
            return;
        }

        Map<String, Map<String, String>> elemPvBeans = GsonUtils.json2WidgetPvMap(elemPvBeanStr);
        if (null == elemPvBeans || elemPvBeans.isEmpty()) {
            MLog.i(TAG, "getExistElemPv -> elemPvBeans is null or empty!");
            return;
        }

        mElemPvBeans.putAll(elemPvBeans);
    }

    private void getExistRecyclerPv() {
        String recyclerPvBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_RECYCLER_PV,
                Constant.SP_VALUE_DEFAULT_EVENT);
        if (TextUtils.isEmpty(recyclerPvBeanStr)) {
            MLog.i(TAG, "getExistRecyclerPv -> recyclerPvBeanStr is null or empty!");
            return;
        }

        Map<String, Map<String, String>> recyclerPvBeans = GsonUtils.json2WidgetPvMap(recyclerPvBeanStr);
        if (null == recyclerPvBeans || recyclerPvBeans.isEmpty()) {
            MLog.i(TAG, "getExistRecyclerPv -> recyclerPvBeans is null or empty!");
            return;
        }

        mRecyclerPvBeans.putAll(recyclerPvBeans);
    }

    private void getExistListPv() {
        String listPvBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_LIST_PV,
                Constant.SP_VALUE_DEFAULT_EVENT);
        if (TextUtils.isEmpty(listPvBeanStr)) {
            MLog.i(TAG, "getExistListPv -> listPvBeanStr is null or empty!");
            return;
        }

        Map<String, Map<String, String>> listPvBeans = GsonUtils.json2WidgetPvMap(listPvBeanStr);
        if (null == listPvBeans || listPvBeans.isEmpty()) {
            MLog.i(TAG, "getExistListPv -> listPvBeans is null or empty!");
            return;
        }

        mListPvBeans.putAll(listPvBeans);
    }

    private void getExistExpandablePv() {
        String expandablePvBeanStr = (String) SpUtils.getParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_EXPANDABLE_PV,
                Constant.SP_VALUE_DEFAULT_EVENT);
        if (TextUtils.isEmpty(expandablePvBeanStr)) {
            MLog.i(TAG, "getExistExpandablePv -> expandablePvBeanStr is null or empty!");
            return;
        }

        Map<String, Map<String, String>> expandablePvBeans = GsonUtils.json2WidgetPvMap(expandablePvBeanStr);
        if (null == expandablePvBeans || expandablePvBeans.isEmpty()) {
            MLog.i(TAG, "getExistExpandablePv -> expandablePvBeans is null or empty!");
            return;
        }

        mExpandablePvBeans.putAll(expandablePvBeans);
    }

    public Set<ContrastItem> getContrastItemList() {
        return mContrastItemList;
    }

    public boolean addContrastItem(String viewPath, String pageClassName) {
        String viewPathMD5 = MD5Utils.getMD5(viewPath);
        boolean add = mContrastItemList.add(new ContrastItem(viewPathMD5, pageClassName));
        MLog.v(TAG, "addContrastItem()-> add viewPath:" + viewPath + ", pageClassName:" + pageClassName + ", add:" + add);
        MonitorListenerController.getInstance().notifyComparisonElementsChange();
        return add;
    }

}