package com.chinapex.android.monitor.global;

import com.chinapex.android.monitor.utils.MD5Utils;

/**
 * @author : Seven Qiu
 * @date : 2019/1/18
 */
public class Constant {

    /**
     * net
     */
    public static final long CONNECT_TIMEOUT = 20;
    public static final long READ_TIMEOUT = 20;
    public static final long WRITE_TIMEOUT = 20;
    public static final int NET_ERROR = -1;
    public static final int NET_SUCCESS = 1;
    public static final int NET_BODY_NULL = 0;
    public static final String HEADER_KEY = "";
    public static final String HEADER_VALUE = "";
    public static final int RESPONSE_OK = 200;

    public static final String SERVER_ROOT = "http://42.159.94.97:8086/";
    public static final String HOSTNAME_VERIFIER = "42.159.94.97";
    public static final String URL_UPLOAD_CONFIG = "app/uploadConfig";
    public static final String URL_PULL_EVENT_DATA = "app/getPageStatistics";
    public static final String URL_PULL_CONTRAST_DATA = "app/getContrastPieChart";
    public static final String URL_GET_ALL_CONFIG_VERSIONS = "app/getAllConfigVersions";
    public static final String URL_DOWNLOAD_CONFIG = "app/downConfig";
    public static final String URL_UPLOAD_SNAPSHOT = "app/uploadSnapshot";
    public static final String URL_DOWN_SANPSHOT = "app/downSnapshot";

    /**
     * sp
     */
    public static final String SP_KEY_EVENT_CONFIG = "event_config";
    public static final String SP_KEY_EVENT_PV = "event_pv";
    public static final String SP_KEY_EVENT_CLICK = "event_click";
    public static final String SP_KEY_EVENT_LIST = "event_list";
    public static final String SP_KEY_EVENT_ELEM_PV = "event_elem_pv";
    public static final String SP_KEY_EVENT_RECYCLER_PV = "event_recycler_pv";
    public static final String SP_KEY_EVENT_LIST_PV = "event_list_pv";
    public static final String SP_KEY_EVENT_EXPANDABLE_PV = "event_expandable_pv";
    public static final String SP_VALUE_DEFAULT_EVENT = "";

    /**
     * 定义的事件类型
     */
    public static final int DEFINE_EVENT_TYPE_CLICK = 1 << 1;
    public static final int DEFINE_EVENT_TYPE_PV = 1 << 2;
    public static final int DEFINE_EVENT_TYPE_LIST = 1 << 3;

    /**
     * default base info
     */
    public static final String DEFAULT_APP_VERSION = "defaultAppVersion";

    /**
     * 上传配置文件时, 携带的终端标识
     */
    public static final String TERMINAL = "ANDROID";

    /**
     * 请求事件点击量或浏览量时，返回的日期单位, d/y/m
     */
    public static final String TIME_UNIT = "d";

    /**
     * 请求事件点击量时横坐标点的个数
     */
    public static final int X_AXIS_COUNTS = 7;

    /**
     * 请求折线图数据时，事件的类型
     */
    public static final String TYPE_ELEMENT = "element";
    public static final String TYPE_PAGE = "page";

    /**
     * view 截图保存路径
     */
    public static final String SNAPSHOT_FILE_DIR = "/.apex/snapshot/";

    /**
     * 图片保存格式
     */
    public static final String BITMAP_STORAGE_SUFFIX = ".png";

    /**
     * 对比图中"其他"项的MD5值，用于区分是否是其他项
     */
    public static final String OTHERS_VIEW_PATH_MD5 = MD5Utils.getMD5("OTHERS_STATISTICS_BEAN");

    /**
     * 配置文件版本号被选中
     */
    public static final int CONFIG_VERSION_CHECKED = 1;
    /**
     * 配置文件版本号未被选中
     */
    public static final int CONFIG_VERSION_UNCHECKED = 0;

    /**
     * 列表点击事件的列表类型
     */
    public static final int LIST_CLICK_TYPE_LIST = 1;
    public static final int LIST_CLICK_TYPE_RECYCLER = 2;
    public static final int LIST_CLICK_TYPE_EXPANDABLE = 3;

    /**
     * 配置文件, 存入外部存储
     */
    public static final String FILE_PREFIX_CONFIG_STORAGE = "apex_config_";
    public static final String FILE_SUFFIX_CONFIG_STORAGE = ".txt";
    public static final String FILE_DIR_CONFIG = "/ApexData/config/";
    public static final String FILE_DATE_PATTERN = "yyyy-MM-dd_HH-mm-ss";
}
