package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.SpUtils;

import java.util.Iterator;
import java.util.Map;

/**
 * @author SteelCabbage
 * @date 2019/03/28
 */
public class WriteRecyclerPvToSp implements Runnable {

    private static final String TAG = WriteRecyclerPvToSp.class.getSimpleName();

    public WriteRecyclerPvToSp() {
    }

    @Override
    public void run() {
        Map<String, Map<String, String>> recyclerPvBeans = MonitorCache.getInstance().getRecyclerPvBeans();
        if (null == recyclerPvBeans) {
            MLog.e(TAG, "run() -> recyclerPvBeans is null!");
            return;
        }

        Iterator<Map.Entry<String, Map<String, String>>> iterator = recyclerPvBeans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, String>> recyclerPvBean = iterator.next();
            if (null == recyclerPvBean) {
                MLog.e(TAG, "run() -> recyclerPvBean is null!");
                continue;
            }

            Map<String, String> recyclerFindPath = recyclerPvBean.getValue();
            if (null == recyclerFindPath || recyclerFindPath.isEmpty()) {
                iterator.remove();
            }
        }

        String recyclerPvBeansJsonStr = GsonUtils.toJsonStr(recyclerPvBeans);
        if (TextUtils.isEmpty(recyclerPvBeansJsonStr)) {
            MLog.e(TAG, "run() -> recyclerPvBeansJsonStr is null or empty!");
            return;
        }

        SpUtils.putParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_RECYCLER_PV, recyclerPvBeansJsonStr);
    }
}
