package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.request.UploadConfigRequest;
import com.chinapex.android.monitor.bean.response.UploadConfigResponse;
import com.chinapex.android.monitor.callback.IWriteConfigToSpCallback;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.FileOpUtils;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.PhoneStateUtils;
import com.chinapex.android.monitor.utils.SpUtils;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

/**
 * @author : Seven Qiu
 * @date : 2019/1/18
 */
public class WriteConfigToSp implements Runnable, INetCallback {

    private static final String TAG = WriteConfigToSp.class.getSimpleName();
    private IWriteConfigToSpCallback mIWriteConfigToSpCallback;

    public WriteConfigToSp(IWriteConfigToSpCallback iWriteConfigToSpCallback) {
        mIWriteConfigToSpCallback = iWriteConfigToSpCallback;
    }

    @Override
    public void run() {
        if (null == mIWriteConfigToSpCallback) {
            MLog.e(TAG, "run() -> mIWriteConfigToSpCallback is null!");
            return;
        }

        UploadConfigRequest uploadConfigRequest = new UploadConfigRequest();
        uploadConfigRequest.setAppVersion(PhoneStateUtils.getVersionName());
        uploadConfigRequest.setTerminal(Constant.TERMINAL);
        uploadConfigRequest.setTimeStamp(System.currentTimeMillis());

        ConfigBean config = new ConfigBean();
        config.setClick(MonitorCache.getInstance().getClickBeans());
        config.setPv(MonitorCache.getInstance().getPvBeans());
        config.setList(MonitorCache.getInstance().getListBeans());
        config.setElemPv(MonitorCache.getInstance().getElemPvBeans());
        config.setRecyclerPv(MonitorCache.getInstance().getRecyclerPvBeans());
        config.setListPv(MonitorCache.getInstance().getListPvBeans());
        config.setExpandablePv(MonitorCache.getInstance().getExpandablePvBeans());
        uploadConfigRequest.setConfig(config);

        String uploadConfigRequestStr = GsonUtils.toJsonStr(uploadConfigRequest);
        if (TextUtils.isEmpty(uploadConfigRequestStr)) {
            MLog.i(TAG, "run() ->  uploadConfigRequestStr is null or empty !");
            return;
        }

        MLog.i(TAG, "run() -> uploadConfigRequestStr:" + uploadConfigRequestStr);
        SpUtils.putParam(MonitorCache.getInstance().getContext(), Constant.SP_KEY_EVENT_CONFIG, uploadConfigRequestStr);
        OkHttpClientManager.getInstance().postJson(
                MonitorCache.getInstance().getServerRoot() + Constant.URL_UPLOAD_CONFIG, uploadConfigRequestStr, this);
        boolean isSuccess = FileOpUtils.write2ExternalFile(Constant.FILE_PREFIX_CONFIG_STORAGE, uploadConfigRequestStr, false);
        MLog.i(TAG, "run() -> write2ExternalFile isSuccess:" + isSuccess);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess() -> result:" + result);
        UploadConfigResponse uploadConfigResponse = GsonUtils.json2Bean(result, UploadConfigResponse.class);
        if (null == uploadConfigResponse) {
            MLog.e(TAG, "onSuccess() -> uploadConfigResponse is null!");
            mIWriteConfigToSpCallback.writeConfigToSp(false);
            return;
        }

        int status = uploadConfigResponse.getStatus();
        if (Constant.RESPONSE_OK != status) {
            MLog.e(TAG, "onSuccess() -> status is not 200! need to upload again!");
            mIWriteConfigToSpCallback.writeConfigToSp(false);
            return;
        }

        boolean isSuccessful = uploadConfigResponse.isData();
        mIWriteConfigToSpCallback.writeConfigToSp(isSuccessful);
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed() -> failedCode:" + failedCode + ", msg:" + msg);
        mIWriteConfigToSpCallback.writeConfigToSp(false);
    }
}
