package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.bean.request.ContrastDataRequest;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

/**
 * @author wyhusky
 * @date 2019/3/7
 */
public class PullContrastData implements Runnable, INetCallback {

    private static final String TAG = PullContrastData.class.getSimpleName();

    private ContrastDataRequest mContrastDataRequest;
    private IUpdateUI iUpdateUI;

    public PullContrastData(ContrastDataRequest contrastDataRequest, IUpdateUI iUpdateUI) {
        this.mContrastDataRequest = contrastDataRequest;
        this.iUpdateUI = iUpdateUI;
    }

    @Override
    public void run() {
        String requestStr = GsonUtils.toJsonStr(mContrastDataRequest);
        if (TextUtils.isEmpty(requestStr)) {
            MLog.e(TAG, "run()-> requestStr is null or empty");
            return;
        }

        MLog.d(TAG, "requestStr:" + requestStr);
        OkHttpClientManager.getInstance().postJson(
                MonitorCache.getInstance().getServerRoot() + Constant.URL_PULL_CONTRAST_DATA, requestStr, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.d(TAG, "onSuccess()-> result:" + result);
        if (TextUtils.isEmpty(result)) {
            MLog.e(TAG, "onSuccess()-> result is null or empty");
            return;
        }
        iUpdateUI.updateUI(true, result);
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "onFailed()-> failedCode:" + failedCode + " msg:" + msg);
        iUpdateUI.updateUI(false, msg);
    }
}
