package com.chinapex.android.monitor.executor.runnable;

import android.text.TextUtils;

import com.chinapex.android.monitor.bean.ConfigBean;
import com.chinapex.android.monitor.bean.request.DownloadConfigRequest;
import com.chinapex.android.monitor.bean.response.DownloadConfigResponse;
import com.chinapex.android.monitor.changelistener.MonitorListenerController;
import com.chinapex.android.monitor.executor.TaskController;
import com.chinapex.android.monitor.global.Constant;
import com.chinapex.android.monitor.global.MonitorCache;
import com.chinapex.android.monitor.utils.GsonUtils;
import com.chinapex.android.monitor.utils.MLog;
import com.chinapex.android.monitor.utils.net.INetCallback;
import com.chinapex.android.monitor.utils.net.OkHttpClientManager;

import java.util.Map;

/**
 * @author SteelCabbage
 * @date 2019/05/13
 */
public class DownloadConfig implements Runnable, INetCallback {

    private static final String TAG = DownloadConfig.class.getSimpleName();
    private String mConfigVersion;

    public DownloadConfig(String configVersion) {
        mConfigVersion = configVersion;
    }

    @Override
    public void run() {
        if (TextUtils.isEmpty(mConfigVersion)) {
            MLog.e(TAG, "run() -> mConfigVersion is null or empty!");
            return;
        }

        DownloadConfigRequest downloadConfigRequest = new DownloadConfigRequest();
        downloadConfigRequest.setAppVersion(mConfigVersion);
        downloadConfigRequest.setTerminal(Constant.TERMINAL);
        downloadConfigRequest.setTimeStamp(0L);

        String downloadConfigRequestStr = GsonUtils.toJsonStr(downloadConfigRequest);
        MLog.d(TAG, "run() -> downloadConfigRequestStr:" + downloadConfigRequestStr);

        OkHttpClientManager.getInstance().postJson(MonitorCache.getInstance().getServerRoot() + Constant.URL_DOWNLOAD_CONFIG,
                downloadConfigRequestStr, this);
    }

    @Override
    public void onSuccess(int statusCode, String msg, String result) {
        MLog.i(TAG, "onSuccess() -> result:" + result);
        if (TextUtils.isEmpty(result)) {
            MLog.e(TAG, "onSuccess() -> result is null or empty!");
            return;
        }

        DownloadConfigResponse downloadConfigResponse = GsonUtils.json2Bean(result, DownloadConfigResponse.class);
        if (null == downloadConfigResponse) {
            MLog.e(TAG, "onSuccess() -> downloadConfigResponse is null!");
            MonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }

        int status = downloadConfigResponse.getStatus();
        if (Constant.RESPONSE_OK != status) {
            MLog.e(TAG, "onSuccess() -> status is not 200!");
            MonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }

        DownloadConfigResponse.DataBean data = downloadConfigResponse.getData();
        if (null == data) {
            MLog.e(TAG, "onSuccess() -> data is null!");
            MonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }

        ConfigBean config = data.getConfig();
        if (null == config) {
            MLog.e(TAG, "onSuccess() -> config is null!");
            MonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }

        Map<String, ConfigBean.ClickBean> clickBeans = MonitorCache.getInstance().getClickBeans();
        Map<String, ConfigBean.PvBean> pvBeans = MonitorCache.getInstance().getPvBeans();
        Map<String, ConfigBean.ListBean> listBeans = MonitorCache.getInstance().getListBeans();
        Map<String, Map<String, String>> elemPvBeans = MonitorCache.getInstance().getElemPvBeans();
        Map<String, Map<String, String>> recyclerPvBeans = MonitorCache.getInstance().getRecyclerPvBeans();
        Map<String, Map<String, String>> listPvBeans = MonitorCache.getInstance().getListPvBeans();
        Map<String, Map<String, String>> expandablePvBeans = MonitorCache.getInstance().getExpandablePvBeans();
        if (null == clickBeans || null == pvBeans || null == listBeans || null == elemPvBeans || null == recyclerPvBeans || null == listPvBeans || null == expandablePvBeans) {
            MLog.e(TAG, "onSuccess() -> clickBeans or pvBeans or listBeans or elemPvBeans or recyclerPvBeans or listPvBeans or " +
                    "expandablePvBeans is null!");
            MonitorListenerController.getInstance().notifyDownloadConfig(false);
            return;
        }

        // 导入的配置文件, 直接覆盖本地已配置的
        clickBeans.clear();
        pvBeans.clear();
        listBeans.clear();
        elemPvBeans.clear();
        recyclerPvBeans.clear();
        listPvBeans.clear();
        expandablePvBeans.clear();

        Map<String, ConfigBean.ClickBean> configClick = config.getClick();
        if (null != configClick) {
            clickBeans.putAll(configClick);
        }

        Map<String, ConfigBean.PvBean> configPv = config.getPv();
        if (null != configPv) {
            pvBeans.putAll(configPv);
        }

        Map<String, ConfigBean.ListBean> configList = config.getList();
        if (null != configList) {
            listBeans.putAll(configList);
        }

        Map<String, Map<String, String>> configElemPv = config.getElemPv();
        if (null != configElemPv) {
            elemPvBeans.putAll(configElemPv);
        }

        Map<String, Map<String, String>> recyclerPv = config.getRecyclerPv();
        if (null != recyclerPv) {
            recyclerPvBeans.putAll(recyclerPv);
        }

        Map<String, Map<String, String>> listPv = config.getListPv();
        if (null != listPv) {
            listPvBeans.putAll(listPv);
        }

        Map<String, Map<String, String>> expandablePv = config.getExpandablePv();
        if (null != expandablePv) {
            expandablePvBeans.putAll(expandablePv);
        }

        MonitorListenerController.getInstance().notifyDownloadConfig(true);

        TaskController.getInstance().submit(new WriteClickToSp());
        TaskController.getInstance().submit(new WritePvToSp());
        TaskController.getInstance().submit(new WriteListToSp());
        TaskController.getInstance().submit(new WriteElemPvToSp());
        TaskController.getInstance().submit(new WriteRecyclerPvToSp());
        TaskController.getInstance().submit(new WriteListPvToSp());
        TaskController.getInstance().submit(new WriteExpandablePvToSp());
    }

    @Override
    public void onFailed(int failedCode, String msg) {
        MLog.e(TAG, "UpdateConfig onFailed() -> msg:" + msg);
        MonitorListenerController.getInstance().notifyDownloadConfig(false);
    }

}
