package com.chinapex.android.monitor.bean;

import java.util.Map;

/**
 * @author SteelCabbage
 * @date 2019/05/13
 */
public class ConfigBean {
    private Map<String, ClickBean> click;
    private Map<String, PvBean> pv;
    private Map<String, ListBean> list;
    private Map<String, Map<String, String>> elemPv;
    private Map<String, Map<String, String>> recyclerPv;
    private Map<String, Map<String, String>> listPv;
    private Map<String, Map<String, String>> expandablePv;

    public Map<String, ClickBean> getClick() {
        return click;
    }

    public void setClick(Map<String, ClickBean> click) {
        this.click = click;
    }

    public Map<String, PvBean> getPv() {
        return pv;
    }

    public void setPv(Map<String, PvBean> pv) {
        this.pv = pv;
    }

    public Map<String, ListBean> getList() {
        return list;
    }

    public void setList(Map<String, ListBean> list) {
        this.list = list;
    }

    public Map<String, Map<String, String>> getElemPv() {
        return elemPv;
    }

    public void setElemPv(Map<String, Map<String, String>> elemPv) {
        this.elemPv = elemPv;
    }

    public Map<String, Map<String, String>> getRecyclerPv() {
        return recyclerPv;
    }

    public void setRecyclerPv(Map<String, Map<String, String>> recyclerPv) {
        this.recyclerPv = recyclerPv;
    }

    public Map<String, Map<String, String>> getListPv() {
        return listPv;
    }

    public void setListPv(Map<String, Map<String, String>> listPv) {
        this.listPv = listPv;
    }

    public Map<String, Map<String, String>> getExpandablePv() {
        return expandablePv;
    }

    public void setExpandablePv(Map<String, Map<String, String>> expandablePv) {
        this.expandablePv = expandablePv;
    }

    public static class ClickBean {
        /**
         * viewPath 唯一路径
         */
        private String viewPath;
        /**
         * 该view的源所属页面
         */
        private String pageClassName;
        /**
         * 该view被定义在哪个页面
         */
        private String definedPage;
        /**
         * 该事件的别名
         */
        private String alias;
        /**
         * 大的更新时, 与之前的同一事件进行关联
         */
        private String preMD5;
        /**
         * 用于查找的路径
         */
        private transient String findPath;

        public String getViewPath() {
            return viewPath;
        }

        public void setViewPath(String viewPath) {
            this.viewPath = viewPath;
        }

        public String getPageClassName() {
            return pageClassName;
        }

        public void setPageClassName(String pageClassName) {
            this.pageClassName = pageClassName;
        }

        public String getDefinedPage() {
            return definedPage;
        }

        public void setDefinedPage(String definedPage) {
            this.definedPage = definedPage;
        }

        public String getAlias() {
            return alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getPreMD5() {
            return preMD5;
        }

        public void setPreMD5(String preMD5) {
            this.preMD5 = preMD5;
        }

        public String getFindPath() {
            return findPath;
        }

        public void setFindPath(String findPath) {
            this.findPath = findPath;
        }
    }

    public static class PvBean {
        /**
         * 页面的唯一路径
         */
        private String viewPath;
        /**
         * 该事件的别名
         */
        private String alias;
        /**
         * 大的更新时, 与之前的同一事件进行关联
         */
        private String preMD5;

        public String getViewPath() {
            return viewPath;
        }

        public void setViewPath(String viewPath) {
            this.viewPath = viewPath;
        }

        public String getAlias() {
            return alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getPreMD5() {
            return preMD5;
        }

        public void setPreMD5(String preMD5) {
            this.preMD5 = preMD5;
        }
    }

    public static class ListBean {
        /**
         * 列表的ID
         */
        private String viewPath;
        /**
         * 该列表的源所属页面
         */
        private String pageClassName;
        /**
         * 该列表被定义在哪个页面
         */
        private String definedPage;
        /**
         * 列表项的别名集合, key: MD5(列表id + dataKey), value: alias
         */
        private Map<String, String> itemAliases;
        /**
         * 用于查找的路径
         */
        private transient String findPath;
        /**
         * 用于查找的路径
         */
        private transient int listType;

        public String getViewPath() {
            return viewPath;
        }

        public void setViewPath(String viewPath) {
            this.viewPath = viewPath;
        }

        public String getPageClassName() {
            return pageClassName;
        }

        public void setPageClassName(String pageClassName) {
            this.pageClassName = pageClassName;
        }

        public String getDefinedPage() {
            return definedPage;
        }

        public void setDefinedPage(String definedPage) {
            this.definedPage = definedPage;
        }

        public Map<String, String> getItemAliases() {
            return itemAliases;
        }

        public void setItemAliases(Map<String, String> itemAliases) {
            this.itemAliases = itemAliases;
        }

        public String getFindPath() {
            return findPath;
        }

        public void setFindPath(String findPath) {
            this.findPath = findPath;
        }

        public int getListType() {
            return listType;
        }

        public void setListType(int listType) {
            this.listType = listType;
        }
    }
}
