/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp.toolbox;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import com.chinamobile.iot.onenet.edp.toolbox.EdpClient;

public class EdpService
extends Service {
    private HeartbeatReceiver mHeartbeatReceiver = new HeartbeatReceiver();
    private EdpClient mEdpClient;

    public static void start(Context context) {
        Intent intent = new Intent(context, EdpService.class);
        context.startService(intent);
    }

    public static void stop(Context context) {
        Intent intent = new Intent(context, EdpService.class);
        context.stopService(intent);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.mEdpClient = EdpClient.getInstance();
        this.mHeartbeatReceiver.register((Context)this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Intent broadcastIntent = new Intent("onenet.edp.intent.ACTION_HEARTBEAT");
        this.sendBroadcast(broadcastIntent);
        return 1;
    }

    public void onDestroy() {
        this.mHeartbeatReceiver.unregister((Context)this);
        super.onDestroy();
    }

    private class HeartbeatReceiver
    extends BroadcastReceiver {
        private HeartbeatReceiver() {
        }

        public void register(Context context) {
            IntentFilter filter = new IntentFilter("onenet.edp.intent.ACTION_HEARTBEAT");
            context.registerReceiver((BroadcastReceiver)this, filter);
        }

        public void unregister(Context context) {
            context.unregisterReceiver((BroadcastReceiver)this);
        }

        public void onReceive(Context context, Intent intent) {
            EdpService.this.mEdpClient.sendHeartbeat();
            EdpService.this.mEdpClient.setupAlarm(context);
        }
    }
}

