/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp.toolbox;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.chinamobile.iot.onenet.edp.CmdRespMsg;
import com.chinamobile.iot.onenet.edp.ConnectMsg;
import com.chinamobile.iot.onenet.edp.EdpKit;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.EncryptMsg;
import com.chinamobile.iot.onenet.edp.EncryptRespMsg;
import com.chinamobile.iot.onenet.edp.PingMsg;
import com.chinamobile.iot.onenet.edp.PushDataMsg;
import com.chinamobile.iot.onenet.edp.SaveDataMsg;
import com.chinamobile.iot.onenet.edp.toolbox.EdpService;
import com.chinamobile.iot.onenet.edp.toolbox.Listener;
import com.chinamobile.iot.onenet.edp.toolbox.RSAUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class EdpClient {
    public static final long DEFAULT_TIMEOUT_MILLI_SECONDS = 240000L;
    private static final long DEFAULT_PING_INTERVAL = 180000L;
    public static final int CONNECT_TYPE_1 = 1;
    public static final int CONNECT_TYPE_2 = 2;
    private String mHost = "jjfaedp.hedevice.com";
    private int mPort = 876;
    private int mPort2 = 29876;
    private long mPingIntervalMilli = 180000L;
    private Socket mEdpSocket;
    private boolean mConnected;
    private LinkedBlockingQueue<Message> mMessageQueue = new LinkedBlockingQueue();
    private int mConnectType;
    private String mDeviceId;
    private String mApikey;
    private String mProjectId;
    private String mAuthInfo;
    private Listener mListener;
    public static final String ACTION_HEARTBEAT = "onenet.edp.intent.ACTION_HEARTBEAT";
    private static EdpClient sInstance;
    private Context mApplicationContext;
    private Handler mHandler = new Handler();
    private int mEncryptAlgorithm;
    private EdpKit mEdpKit = new EdpKit();
    private String mSectetKey;
    private BigInteger mModulus;
    private BigInteger mPublicExponent;
    private BigInteger mPrivateExponent;
    private RSAPublicKey mPublicKey;
    private RSAPrivateKey mPrivateKey;

    public static void initialize(Context context, int type, String id, String authinfo) {
        sInstance = new EdpClient(context, type, id, authinfo);
    }

    public static EdpClient getInstance() {
        if (null == sInstance) {
            throw new RuntimeException("You must call EdpClient.initialize() first");
        }
        return sInstance;
    }

    private EdpClient(Context context, int type, String id, String authinfo) {
        this.mApplicationContext = context.getApplicationContext();
        this.mConnectType = type;
        if (1 == this.mConnectType) {
            this.mDeviceId = id;
            this.mApikey = authinfo;
        } else if (2 == this.mConnectType) {
            this.mProjectId = id;
            this.mAuthInfo = authinfo;
        }
    }

    public void setPingInterval(long milliseconds) {
        if (milliseconds >= 240000L) {
            throw new IllegalArgumentException("ping interval can not be longer than 4 min");
        }
        this.mPingIntervalMilli = milliseconds;
    }

    private void sendFile(String filePath, OutputStream outputStream) throws IOException {
        int size;
        FileInputStream fis = new FileInputStream(filePath);
        byte[] buffer = new byte[1024];
        while ((size = fis.read(buffer)) > 0) {
            outputStream.write(buffer, 0, size);
        }
        outputStream.flush();
        fis.close();
    }

    private byte[] readRecvPacket(InputStream inputStream) throws IOException {
        int size;
        byte[] buffer = new byte[1024];
        byte[] recvPacket = null;
        int pos = 0;
        while ((size = inputStream.read(buffer)) > 0) {
            if (null == recvPacket) {
                recvPacket = new byte[size];
                System.arraycopy(buffer, 0, recvPacket, pos, size);
            } else {
                byte[] temp = new byte[pos + size];
                System.arraycopy(recvPacket, 0, temp, 0, pos);
                System.arraycopy(buffer, 0, temp, pos, size);
                recvPacket = temp;
            }
            if (size < 1024) break;
            pos += size;
        }
        if (size <= 0) {
            recvPacket = null;
        }
        return recvPacket;
    }

    public void connect() {
        if (this.mConnected) {
            return;
        }
        new ConnectThreat().start();
    }

    public void connect(String host, int port) {
        if (TextUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("host can not be empty");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("port " + port + " is illegal");
        }
        this.mHost = host;
        this.mPort = port;
        this.connect();
    }

    public void disconnect() {
        this.mConnected = false;
        if (this.mEdpSocket != null) {
            try {
                this.mEdpSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.mEdpSocket = null;
            }
        }
        EdpService.stop(this.mApplicationContext);
        Message msg = new Message();
        msg.setType(3);
        this.enqueueMsg(msg);
        this.mMessageQueue.clear();
    }

    public void setListener(Listener l) {
        this.mListener = l;
    }

    public void sendConnectReq() {
        ConnectMsg connectMsg = new ConnectMsg();
        if (this.mEncryptAlgorithm > -1 && !TextUtils.isEmpty((CharSequence)this.mSectetKey)) {
            connectMsg.setAlgorithm(this.mEncryptAlgorithm);
            connectMsg.setSecretKey(this.mSectetKey);
        }
        Message msg = new Message();
        msg.setType(1);
        byte[] packet = null;
        switch (this.mConnectType) {
            case 1: {
                packet = connectMsg.packMsg(this.mDeviceId, this.mApikey);
                break;
            }
            case 2: {
                packet = connectMsg.packMsg("0", this.mProjectId, this.mAuthInfo);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown connect type: " + this.mConnectType);
            }
        }
        msg.setPacket(packet);
        this.enqueueMsg(msg);
    }

    public void sendHeartbeat() {
        PingMsg pingMsg = new PingMsg();
        if (this.mEncryptAlgorithm > -1 && !TextUtils.isEmpty((CharSequence)this.mSectetKey)) {
            pingMsg.setAlgorithm(this.mEncryptAlgorithm);
            pingMsg.setSecretKey(this.mSectetKey);
        }
        Message msg = new Message();
        msg.setType(1);
        msg.setPacket(pingMsg.packMsg());
        this.enqueueMsg(msg);
    }

    public void pushData(long deviceId, byte[] data) {
        Message msg = new Message();
        PushDataMsg pushDataMsg = new PushDataMsg();
        if (this.mEncryptAlgorithm > -1 && !TextUtils.isEmpty((CharSequence)this.mSectetKey)) {
            pushDataMsg.setAlgorithm(this.mEncryptAlgorithm);
            pushDataMsg.setSecretKey(this.mSectetKey);
        }
        try {
            msg.setType(1);
            msg.setPacket(pushDataMsg.packMsg(deviceId, data));
            this.enqueueMsg(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void pushData(long deviceId, String data) {
        Message msg = new Message();
        PushDataMsg pushDataMsg = new PushDataMsg();
        if (this.mEncryptAlgorithm > -1 && !TextUtils.isEmpty((CharSequence)this.mSectetKey)) {
            pushDataMsg.setAlgorithm(this.mEncryptAlgorithm);
            pushDataMsg.setSecretKey(this.mSectetKey);
        }
        try {
            msg.setType(1);
            msg.setPacket(pushDataMsg.packMsg(deviceId, data));
            this.enqueueMsg(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveData(String desDeviceId, int dataType, String tokenStr, byte[] data) {
        Message msg = new Message();
        SaveDataMsg saveDataMsg = new SaveDataMsg();
        if (this.mEncryptAlgorithm > -1 && !TextUtils.isEmpty((CharSequence)this.mSectetKey)) {
            saveDataMsg.setAlgorithm(this.mEncryptAlgorithm);
            saveDataMsg.setSecretKey(this.mSectetKey);
        }
        msg.setType(1);
        boolean flag = saveDataMsg.packMsg(desDeviceId, dataType, tokenStr, data);
        if (flag) {
            msg.setPacket(saveDataMsg.commit());
            this.enqueueMsg(msg);
        }
    }

    public void sendCmdResp(String cmdid, byte[] data) {
        Message msg = new Message();
        CmdRespMsg cmdRespMsg = new CmdRespMsg();
        if (this.mEncryptAlgorithm > -1 && !TextUtils.isEmpty((CharSequence)this.mSectetKey)) {
            cmdRespMsg.setAlgorithm(this.mEncryptAlgorithm);
            cmdRespMsg.setSecretKey(this.mSectetKey);
        }
        msg.setType(1);
        msg.setPacket(cmdRespMsg.packMsg(cmdid, data));
        this.enqueueMsg(msg);
    }

    public void requestEncrypt(int algorithm) {
        if (algorithm > -1) {
            this.mEncryptAlgorithm = algorithm;
            try {
                this.generateEncryptInfo();
                EncryptMsg encryptMsg = new EncryptMsg();
                Message msg = new Message();
                msg.setType(1);
                msg.setPacket(encryptMsg.packMsg(this.mModulus, this.mPublicExponent, algorithm));
                this.enqueueMsg(msg);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    public void setupAlarm(Context context) {
        Intent intent = new Intent(ACTION_HEARTBEAT);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        this.setupAlarm(context, this.mPingIntervalMilli, pendingIntent);
    }

    public void setupAlarm(Context context, long timeIntervalMillis, PendingIntent pendingIntent) {
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        am.cancel(pendingIntent);
        long triggerAtMillis = SystemClock.elapsedRealtime() + timeIntervalMillis;
        if (Build.VERSION.SDK_INT >= 23) {
            am.setExactAndAllowWhileIdle(2, triggerAtMillis, pendingIntent);
        } else if (Build.VERSION.SDK_INT >= 19) {
            am.setExact(2, triggerAtMillis, pendingIntent);
        } else {
            am.set(2, triggerAtMillis, pendingIntent);
        }
    }

    public void cancelAlarm(Context context) {
        Intent intent = new Intent(ACTION_HEARTBEAT);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        this.cancelAlarm(context, pendingIntent);
    }

    public void cancelAlarm(Context context, PendingIntent pendingIntent) {
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        am.cancel(pendingIntent);
    }

    private void enqueueMsg(Message msg) {
        this.mMessageQueue.offer(msg);
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    private void generateEncryptInfo() throws NoSuchAlgorithmException {
        HashMap<String, Object> map = RSAUtils.getKeys();
        this.mPublicKey = (RSAPublicKey)map.get("public");
        this.mPrivateKey = (RSAPrivateKey)map.get("private");
        this.mModulus = this.mPublicKey.getModulus();
        Log.i((String)"OneNetApp", (String)("n = " + this.mModulus.toString()));
        this.mPublicExponent = this.mPublicKey.getPublicExponent();
        Log.i((String)"OneNetApp", (String)("e = " + this.mPublicExponent.toString()));
        this.mPrivateExponent = this.mPrivateKey.getPrivateExponent();
        Log.i((String)"OneNetApp", (String)("d = " + this.mPrivateExponent.toString()));
    }

    public String rsaEncrypt(String plainText) throws Exception {
        if (this.mPublicKey != null) {
            return RSAUtils.encryptByPublicKey(plainText, this.mPublicKey);
        }
        return plainText;
    }

    public String rsaDecrypt(String cipherText) throws Exception {
        if (this.mPrivateKey != null) {
            return RSAUtils.decryptByPrivateKey(cipherText, this.mPrivateKey);
        }
        return cipherText;
    }

    private class DisconnectEvent
    implements Runnable {
        private DisconnectEvent() {
        }

        @Override
        public void run() {
            if (EdpClient.this.mListener != null) {
                EdpClient.this.mListener.onDisconnect();
            }
        }
    }

    private class FailedEvent
    implements Runnable {
        private Exception mException;

        public FailedEvent(Exception e) {
            this.mException = e;
        }

        @Override
        public void run() {
            if (EdpClient.this.mListener != null) {
                EdpClient.this.mListener.onFailed(this.mException);
            }
        }
    }

    private class ReceiveEvent
    implements Runnable {
        private List<EdpMsg> mMsgList;

        public ReceiveEvent(List<EdpMsg> msgList) {
            this.mMsgList = msgList;
        }

        @Override
        public void run() {
            if (EdpClient.this.mListener != null) {
                EdpClient.this.mListener.onReceive(this.mMsgList);
            }
        }
    }

    class Message {
        public static final int BYTES = 1;
        public static final int FILE = 2;
        public static final int DISCONNECT = 3;
        private int type;
        private byte[] packet;
        private String filePath;

        Message() {
        }

        public int getType() {
            return this.type;
        }

        public Message setType(int type) {
            this.type = type;
            return this;
        }

        public byte[] getPacket() {
            return this.packet;
        }

        public Message setPacket(byte[] packet) {
            this.packet = packet;
            return this;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Message setFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }
    }

    private class RecvMessageThread
    extends Thread {
        private RecvMessageThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream inputStream = null;
            try {
                while (null != EdpClient.this.mEdpSocket) {
                    inputStream = EdpClient.this.mEdpSocket.getInputStream();
                    EdpClient.this.mConnected = true;
                    byte[] recvPacket = EdpClient.this.readRecvPacket(inputStream);
                    if (null == recvPacket) {
                        break;
                    }
                    List<EdpMsg> msgList = EdpClient.this.mEdpKit.unpack(recvPacket, EdpClient.this.mEncryptAlgorithm, EdpClient.this.mSectetKey);
                    if (EdpClient.this.mListener == null || msgList == null) continue;
                    for (EdpMsg msg : msgList) {
                        if (msg == null) continue;
                        byte type = msg.getMsgType();
                        if (32 == type) {
                            EdpService.start(EdpClient.this.mApplicationContext.getApplicationContext());
                            continue;
                        }
                        if (-16 != type) continue;
                        EncryptRespMsg encryptRespMsg = (EncryptRespMsg)msg;
                        try {
                            EdpClient.this.mSectetKey = EdpClient.this.rsaDecrypt(encryptRespMsg.getEncryptSecretKey());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    EdpClient.this.mHandler.post((Runnable)new ReceiveEvent(msgList));
                }
            }
            catch (IOException e) {
                if (EdpClient.this.mListener != null && EdpClient.this.mConnected) {
                    EdpClient.this.mHandler.post((Runnable)new FailedEvent(e));
                }
            }
            finally {
                Message msg = new Message();
                msg.setType(3);
                EdpClient.this.enqueueMsg(msg);
                EdpClient.this.mConnected = false;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class SendMessageThread
    extends Thread {
        private Exception mException;

        private SendMessageThread() {
        }

        @Override
        public void run() {
            block22: {
                OutputStream outputStream = null;
                try {
                    while (true) {
                        if (null == EdpClient.this.mEdpSocket) {
                            break block22;
                        }
                        outputStream = EdpClient.this.mEdpSocket.getOutputStream();
                        EdpClient.this.mConnected = true;
                        Message msg = (Message)EdpClient.this.mMessageQueue.take();
                        if (msg.getType() == 1) {
                            outputStream.write(msg.getPacket());
                            continue;
                        }
                        if (msg.getType() == 2) {
                            EdpClient.this.sendFile(msg.getFilePath(), outputStream);
                            continue;
                        }
                        if (msg.getType() == 3) break;
                    }
                    if (EdpClient.this.mListener != null) {
                        EdpClient.this.mHandler.post((Runnable)new DisconnectEvent());
                    }
                }
                catch (IOException e) {
                    this.mException = e;
                }
                catch (InterruptedException e) {
                    this.mException = e;
                }
                finally {
                    if (this.mException != null && EdpClient.this.mListener != null && EdpClient.this.mConnected) {
                        EdpClient.this.mHandler.post((Runnable)new FailedEvent(this.mException));
                    }
                    EdpClient.this.mConnected = false;
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private class ConnectThreat
    extends Thread {
        private ConnectThreat() {
        }

        @Override
        public void run() {
            try {
                EdpClient.this.mEdpSocket = new Socket(EdpClient.this.mHost, EdpClient.this.mPort);
                Thread.sleep(1000L);
                new RecvMessageThread().start();
                new SendMessageThread().start();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (EdpClient.this.mListener != null && EdpClient.this.mConnected) {
                    EdpClient.this.mHandler.post((Runnable)new FailedEvent(e));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

