/*
 * Decompiled with CFR 0.152.
 */
package com.chinamobile.iot.onenet.edp;

import android.text.TextUtils;
import com.chinamobile.iot.onenet.edp.Common;
import com.chinamobile.iot.onenet.edp.EdpMsg;
import com.chinamobile.iot.onenet.edp.toolbox.AESUtils;
import java.io.IOException;

public class SaveRespMsg
extends EdpMsg {
    private boolean hasResp;
    private int dataLength;
    private byte[] data;

    public SaveRespMsg() {
        super((byte)-112);
    }

    @Override
    public void unpackMsg(byte[] msgData) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)this.getSecretKey())) {
            switch (this.getAlgorithm()) {
                case 1: {
                    try {
                        msgData = AESUtils.decrypt(msgData, this.getSecretKey().getBytes());
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int dataLen = msgData.length;
        this.hasResp = msgData[0] == -128;
        int dataRemain = dataLen - 1;
        if (dataRemain < 2) {
            throw new IOException("[sava_resp] data too short. dataLen=" + dataLen);
        }
        int respDataLen = Common.twoByteToLen(msgData[1], msgData[2]);
        if (respDataLen > (dataRemain -= 2)) {
            throw new IOException("[save_resp] resp_data too long. respDataLen=" + respDataLen + " dataRemain=" + dataRemain);
        }
        this.data = new byte[respDataLen];
        System.arraycopy(msgData, 3, this.data, 0, respDataLen);
    }

    public boolean getHasResp() {
        return this.hasResp;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public byte[] getData() {
        return this.data;
    }
}

